/*
 * Purpose: This header file contains some coefficients for the 4 band equalizer
 *
 * This equalizer code is used by the SB Live/Audigy firmware and the old
 * softoss driver.
 */
/*
 *
 * This file is part of Open Sound System.
 *
 * Copyright (C) 4Front Technologies 1996-2008.
 *
 * This this source file is released under GPL v2 license (no other versions).
 * See the COPYING file included in the main directory of this source
 * distribution for the license terms and conditions.
 *
 */
static const unsigned int eq_band1_data[][6] = {
  {0x0FCEBCE0, 0xE083F660, 0x1F7C09A0, 0x0FADB020, 0xF08392F0, 0x00000000},	/* 0 */
  {0x0FCF2D70, 0xE0834400, 0x1F7CBC00, 0x0FADF220, 0xF082E090, 0x00000000},	/* 1 */
  {0x0FCF9D80, 0xE08292A0, 0x1F7D6D60, 0x0FAE3370, 0xF0822F10, 0x00000000},	/* 2 */
  {0x0FD00D40, 0xE081E220, 0x1F7E1DE0, 0x0FAE7430, 0xF0817E90, 0x00000000},	/* 3 */
  {0x0FD07CB0, 0xE0813280, 0x1F7ECD80, 0x0FAEB450, 0xF080CEF0, 0x00000000},	/* 4 */
  {0x0FD0EBE0, 0xE08083A0, 0x1F7F7C60, 0x0FAEF410, 0xF0802030, 0x00000000},	/* 5 */
  {0x0FD15A90, 0xE07FD600, 0x1F802A00, 0x0FAF32F0, 0xF07F7260, 0x00000000},	/* 6 */
  {0x0FD1C910, 0xE07F2940, 0x1F80D6C0, 0x0FAF7150, 0xF07EC590, 0x00000000},	/* 7 */
  {0x0FD23740, 0xE07E7D20, 0x1F8182E0, 0x0FAFAF30, 0xF07E1990, 0x00000000},	/* 8 */
  {0x0FD2A510, 0xE07DD200, 0x1F822E00, 0x0FAFEC70, 0xF07D6E70, 0x00000000},	/* 9 */
  {0x0FD312A0, 0xE07D27E0, 0x1F82D820, 0x0FB02930, 0xF07CC440, 0x00000000},	/* 10 */
  {0x0FD37FC0, 0xE07C7EA0, 0x1F838160, 0x0FB06540, 0xF07C1B00, 0x00000000},	/* 11 */
  {0x0FD3ECC0, 0xE07BD620, 0x1F8429E0, 0x0FB0A0D0, 0xF07B7290, 0x00000000},	/* 12 */
  {0x0FD45930, 0xE07B2EC0, 0x1F84D140, 0x0FB0DBB0, 0xF07ACB10, 0x00000000},	/* 13 */
  {0x0FD4C5A0, 0xE07A87E0, 0x1F857820, 0x0FB11620, 0xF07A2450, 0x00000000},	/* 14 */
  {0x0FD531A0, 0xE079E220, 0x1F861DE0, 0x0FB14FF0, 0xF0797E80, 0x00000000},	/* 15 */
  {0x0FD59D40, 0xE0793D20, 0x1F86C2E0, 0x0FB18930, 0xF078D990, 0x00000000},	/* 16 */
  {0x0FD608A0, 0xE0789920, 0x1F8766E0, 0x0FB1C1E0, 0xF0783580, 0x00000000},	/* 17 */
  {0x0FD673B0, 0xE077F600, 0x1F880A00, 0x0FB1F9F0, 0xF0779250, 0x00000000},	/* 18 */
  {0x0FD6DE80, 0xE07753A0, 0x1F88AC60, 0x0FB23180, 0xF076F000, 0x00000000},	/* 19 */
  {0x0FD74920, 0xE076B220, 0x1F894DE0, 0x0FB26880, 0xF0764E70, 0x00000000},	/* 20 */
  {0x0FD7B340, 0xE07611A0, 0x1F89EE60, 0x0FB29ED0, 0xF075ADE0, 0x00000000},	/* 21 */
  {0x0FD81D20, 0xE07571C0, 0x1F8A8E40, 0x0FB2D4B0, 0xF0750E10, 0x00000000},	/* 22 */
  {0x0FD886F0, 0xE074D2A0, 0x1F8B2D60, 0x0FB30A10, 0xF0746F00, 0x00000000},	/* 23 */
  {0x0FD8F060, 0xE0743480, 0x1F8BCB80, 0x0FB33EC0, 0xF073D0D0, 0x00000000},	/* 24 */
  {0x0FD95980, 0xE0739740, 0x1F8C68C0, 0x0FB372F0, 0xF0733390, 0x00000000},	/* 25 */
  {0x0FD9C260, 0xE072FAC0, 0x1F8D0540, 0x0FB3A690, 0xF0729700, 0x00000000},	/* 26 */
  {0x0FDA2B00, 0xE0725F00, 0x1F8DA100, 0x0FB3D9B0, 0xF071FB40, 0x00000000},	/* 27 */
  {0x0FDA9350, 0xE071C420, 0x1F8E3BE0, 0x0FB40C40, 0xF0716070, 0x00000000},	/* 28 */
  {0x0FDAFB60, 0xE0712A40, 0x1F8ED5C0, 0x0FB43E20, 0xF070C670, 0x00000000},	/* 29 */
  {0x0FDB6340, 0xE07090C0, 0x1F8F6F40, 0x0FB46FA0, 0xF0702D20, 0x00000000},	/* 30 */
  {0x0FDBCAE0, 0xE06FF840, 0x1F9007C0, 0x0FB4A090, 0xF06F94A0, 0x00000000},	/* 31 */
  {0x0FDC3220, 0xE06F60C0, 0x1F909F40, 0x0FB4D0E0, 0xF06EFD00, 0x00000000},	/* 32 */
  {0x0FDC9930, 0xE06EC9E0, 0x1F913620, 0x0FB50090, 0xF06E6630, 0x00000000},	/* 33 */
  {0x0FDD0020, 0xE06E33C0, 0x1F91CC40, 0x0FB52FF0, 0xF06DD010, 0x00000000},	/* 34 */
  {0x0FDD6690, 0xE06D9EA0, 0x1F926160, 0x0FB55E80, 0xF06D3AD0, 0x00000000},	/* 35 */
  {0x0FDDCCF0, 0xE06D0A20, 0x1F92F5E0, 0x0FB58CB0, 0xF06CA650, 0x00000000},	/* 36 */
  {0x0FDE3310, 0xE06C7660, 0x1F9389A0, 0x0FB5BA50, 0xF06C1290, 0x00000000},	/* 37 */
  {0x0FDE98F0, 0xE06BE360, 0x1F941CA0, 0x0FB5E770, 0xF06B7F90, 0x00000000},	/* 38 */
  {0x0FDEFEA0, 0xE06B5140, 0x1F94AEC0, 0x0FB613E0, 0xF06AED80, 0x00000000},	/* 39 */
  {0x0FDF6410, 0xE06ABFE0, 0x1F954020, 0x0FB63FF0, 0xF06A5C00, 0x00000000},	/* 40 */
  {0x0FDFC940, 0xE06A2F40, 0x1F95D0C0, 0x0FB66B60, 0xF069CB70, 0x00000000},	/* 41 */
  {0x0FE02E40, 0xE0699F40, 0x1F9660C0, 0x0FB69650, 0xF0693B70, 0x00000000},	/* 42 */
  {0x0FE092E0, 0xE0691040, 0x1F96EFC0, 0x0FB6C0A0, 0xF068AC60, 0x00000000},	/* 43 */
  {0x0FE0F780, 0xE06881C0, 0x1F977E40, 0x0FB6EAA0, 0xF0681DF0, 0x00000000},	/* 44 */
  {0x0FE15BD0, 0xE067F420, 0x1F980BE0, 0x0FB713E0, 0xF0679050, 0x00000000},	/* 45 */
  {0x0FE1BFE0, 0xE0676740, 0x1F9898C0, 0x0FB73CB0, 0xF0670370, 0x00000000},	/* 46 */
  {0x0FE223D0, 0xE066DB20, 0x1F9924E0, 0x0FB764F0, 0xF0667740, 0x00000000},	/* 47 */
  {0x0FE28790, 0xE0664FA0, 0x1F99B060, 0x0FB78CB0, 0xF065EBD0, 0x00000000},	/* 48 */
  {0x0FE2EB10, 0xE065C4E0, 0x1F9A3B20, 0x0FB7B3F0, 0xF0656120, 0x00000000},	/* 49 */
  {0x0FE34E30, 0xE0653B20, 0x1F9AC4E0, 0x0FB7DA80, 0xF064D730, 0x00000000},	/* 50 */
  {0x0FE3B150, 0xE064B1E0, 0x1F9B4E20, 0x0FB800C0, 0xF0644DF0, 0x00000000},	/* 51 */
  {0x0FE41440, 0xE0642940, 0x1F9BD6C0, 0x0FB82650, 0xF063C560, 0x00000000},	/* 52 */
  {0x0FE476F0, 0xE063A1A0, 0x1F9C5E60, 0x0FB84B70, 0xF0633DA0, 0x00000000},	/* 53 */
  {0x0FE4D960, 0xE0631A60, 0x1F9CE5A0, 0x0FB87000, 0xF062B680, 0x00000000},	/* 54 */
  {0x0FE53BE0, 0xE0629400, 0x1F9D6C00, 0x0FB89420, 0xF0623020, 0x00000000},	/* 55 */
  {0x0FE59DE0, 0xE0620E80, 0x1F9DF180, 0x0FB8B790, 0xF061AA80, 0x00000000},	/* 56 */
  {0x0FE5FFE0, 0xE0618980, 0x1F9E7680, 0x0FB8DA90, 0xF0612590, 0x00000000},	/* 57 */
  {0x0FE661B0, 0xE0610520, 0x1F9EFAE0, 0x0FB8FD20, 0xF060A140, 0x00000000},	/* 58 */
  {0x0FE6C330, 0xE06081A0, 0x1F9F7E60, 0x0FB91F20, 0xF0601DA0, 0x00000000},	/* 59 */
  {0x0FE724A0, 0xE05FFEC0, 0x1FA00140, 0x0FB94090, 0xF05F9AC0, 0x00000000},	/* 60 */
  {0x0FE785F0, 0xE05F7C80, 0x1FA08380, 0x0FB96180, 0xF05F1890, 0x00000000},	/* 61 */
  {0x0FE7E6F0, 0xE05EFB20, 0x1FA104E0, 0x0FB981E0, 0xF05E9710, 0x00000000},	/* 62 */
  {0x0FE847F0, 0xE05E7A20, 0x1FA185E0, 0x0FB9A1E0, 0xF05E1620, 0x00000000},	/* 63 */
  {0x0FE8A8B0, 0xE05DFA20, 0x1FA205E0, 0x0FB9C130, 0xF05D9610, 0x00000000},	/* 64 */
  {0x0FE90950, 0xE05D7AA0, 0x1FA28560, 0x0FB9E010, 0xF05D1690, 0x00000000},	/* 65 */
  {0x0FE969C0, 0xE05CFBC0, 0x1FA30440, 0x0FB9FE80, 0xF05C97C0, 0x00000000},	/* 66 */
  {0x0FE9CA00, 0xE05C7DA0, 0x1FA38260, 0x0FBA1C50, 0xF05C19B0, 0x00000000},	/* 67 */
  {0x0FEA2A30, 0xE05C0000, 0x1FA40000, 0x0FBA39C0, 0xF05B9C10, 0x00000000},	/* 68 */
  {0x0FEA8A30, 0xE05B8360, 0x1FA47CA0, 0x0FBA5680, 0xF05B1F60, 0x00000000},	/* 69 */
  {0x0FEAEA00, 0xE05B0720, 0x1FA4F8E0, 0x0FBA72D0, 0xF05AA320, 0x00000000},	/* 70 */
  {0x0FEB49A0, 0xE05A8BC0, 0x1FA57440, 0x0FBA8EA0, 0xF05A27B0, 0x00000000},	/* 71 */
  {0x0FEBA920, 0xE05A10E0, 0x1FA5EF20, 0x0FBAA9E0, 0xF059ACE0, 0x00000000},	/* 72 */
  {0x0FEC08A0, 0xE05996A0, 0x1FA66960, 0x0FBAC4C0, 0xF05932A0, 0x00000000},	/* 73 */
  {0x0FEC67F0, 0xE0591D20, 0x1FA6E2E0, 0x0FBADF00, 0xF058B910, 0x00000000},	/* 74 */
  {0x0FECC710, 0xE058A400, 0x1FA75C00, 0x0FBAF8E0, 0xF0584010, 0x00000000},	/* 75 */
  {0x0FED2600, 0xE0582BE0, 0x1FA7D420, 0x0FBB1210, 0xF057C7E0, 0x00000000},	/* 76 */
  {0x0FED84F0, 0xE057B440, 0x1FA84BC0, 0x0FBB2AD0, 0xF0575030, 0x00000000},	/* 77 */
  {0x0FEDE3D0, 0xE0573D20, 0x1FA8C2E0, 0x0FBB4330, 0xF056D910, 0x00000000},	/* 78 */
  {0x0FEE4240, 0xE056C6E0, 0x1FA93920, 0x0FBB5AE0, 0xF05662C0, 0x00000000},	/* 79 */
  {0x0FEEA100, 0xE05650E0, 0x1FA9AF20, 0x0FBB7230, 0xF055ECE0, 0x00000000},	/* 80 */
  {0x0FEEFF40, 0xE055DBE0, 0x1FAA2420, 0x0FBB88F0, 0xF05577D0, 0x00000000},	/* 81 */
  {0x0FEF5D80, 0xE0556760, 0x1FAA98A0, 0x0FBB9F20, 0xF0550350, 0x00000000},	/* 82 */
  {0x0FEFBBD0, 0xE054F340, 0x1FAB0CC0, 0x0FBBB500, 0xF0548F50, 0x00000000},	/* 83 */
  {0x0FF019E0, 0xE0548000, 0x1FAB8000, 0x0FBBCA30, 0xF0541BF0, 0x00000000},	/* 84 */
  {0x0FF077C0, 0xE0540D60, 0x1FABF2A0, 0x0FBBDEF0, 0xF053A940, 0x00000000},	/* 85 */
  {0x0FF0D5B0, 0xE0539B40, 0x1FAC64C0, 0x0FBBF330, 0xF0533730, 0x00000000},	/* 86 */
  {0x0FF13370, 0xE05329E0, 0x1FACD620, 0x0FBC06F0, 0xF052C5B0, 0x00000000},	/* 87 */
  {0x0FF19100, 0xE052B8E0, 0x1FAD4720, 0x0FBC1A20, 0xF05254C0, 0x00000000},	/* 88 */
  {0x0FF1EEA0, 0xE05248A0, 0x1FADB760, 0x0FBC2CE0, 0xF051E490, 0x00000000},	/* 89 */
  {0x0FF24C20, 0xE051D900, 0x1FAE2700, 0x0FBC3F20, 0xF05174D0, 0x00000000},	/* 90 */
  {0x0FF2A980, 0xE05169A0, 0x1FAE9660, 0x0FBC50F0, 0xF05105A0, 0x00000000},	/* 91 */
  {0x0FF306C0, 0xE050FB20, 0x1FAF04E0, 0x0FBC6240, 0xF0509710, 0x00000000},	/* 92 */
  {0x0FF363E0, 0xE0508D60, 0x1FAF72A0, 0x0FBC72E0, 0xF0502930, 0x00000000},	/* 93 */
  {0x0FF3C0F0, 0xE0502000, 0x1FAFE000, 0x0FBC8320, 0xF04FBBD0, 0x00000000},	/* 94 */
  {0x0FF41E20, 0xE04FB320, 0x1FB04CE0, 0x0FBC92F0, 0xF04F4F00, 0x00000000},	/* 95 */
  {0x0FF47AF0, 0xE04F4700, 0x1FB0B900, 0x0FBCA220, 0xF04EE2D0, 0x00000000},	/* 96 */
  {0x0FF4D7E0, 0xE04EDB60, 0x1FB124A0, 0x0FBCB0E0, 0xF04E7730, 0x00000000},	/* 97 */
  {0x0FF534B0, 0xE04E7040, 0x1FB18FC0, 0x0FBCBF40, 0xF04E0C10, 0x00000000},	/* 98 */
  {0x0FF59170, 0xE04E05C0, 0x1FB1FA40, 0x0FBCCCF0, 0xF04DA190, 0x00000000},	/* 99 */
  {0x0FF5EE00, 0xE04D9BE0, 0x1FB26420, 0x0FBCDA40, 0xF04D3790, 0x00000000},	/* 100 */
  {0x0FF64AC0, 0xE04D3260, 0x1FB2CDA0, 0x0FBCE720, 0xF04CCE30, 0x00000000},	/* 101 */
  {0x0FF6A740, 0xE04CC9A0, 0x1FB33660, 0x0FBCF360, 0xF04C6560, 0x00000000},	/* 102 */
  {0x0FF703B0, 0xE04C6140, 0x1FB39EC0, 0x0FBCFF30, 0xF04BFD20, 0x00000000},	/* 103 */
  {0x0FF76030, 0xE04BF980, 0x1FB40680, 0x0FBD0A80, 0xF04B9550, 0x00000000},	/* 104 */
  {0x0FF7BC80, 0xE04B9260, 0x1FB46DA0, 0x0FBD1550, 0xF04B2E30, 0x00000000},	/* 105 */
  {0x0FF818E0, 0xE04B2BA0, 0x1FB4D460, 0x0FBD1FB0, 0xF04AC770, 0x00000000},	/* 106 */
  {0x0FF87510, 0xE04AC5C0, 0x1FB53A40, 0x0FBD2970, 0xF04A6170, 0x00000000},	/* 107 */
  {0x0FF8D160, 0xE04A6020, 0x1FB59FE0, 0x0FBD32D0, 0xF049FBE0, 0x00000000},	/* 108 */
  {0x0FF92D90, 0xE049FB00, 0x1FB60500, 0x0FBD3BB0, 0xF04996D0, 0x00000000},	/* 109 */
  {0x0FF989B0, 0xE0499680, 0x1FB66980, 0x0FBD4400, 0xF0493250, 0x00000000},	/* 110 */
  {0x0FF9E5C0, 0xE04932A0, 0x1FB6CD60, 0x0FBD4BE0, 0xF048CE60, 0x00000000},	/* 111 */
  {0x0FFA41E0, 0xE048CF20, 0x1FB730E0, 0x0FBD5340, 0xF0486AE0, 0x00000000},	/* 112 */
  {0x0FFA9DC0, 0xE0486C60, 0x1FB793A0, 0x0FBD5A10, 0xF0480820, 0x00000000},	/* 113 */
  {0x0FFAF9E0, 0xE04809E0, 0x1FB7F620, 0x0FBD6080, 0xF047A5B0, 0x00000000},	/* 114 */
  {0x0FFB55C0, 0xE047A820, 0x1FB857E0, 0x0FBD6650, 0xF04743D0, 0x00000000},	/* 115 */
  {0x0FFBB1E0, 0xE04746A0, 0x1FB8B960, 0x0FBD6BD0, 0xF046E270, 0x00000000},	/* 116 */
  {0x0FFC0DC0, 0xE046E5C0, 0x1FB91A40, 0x0FBD70C0, 0xF04681A0, 0x00000000},	/* 117 */
  {0x0FFC69B0, 0xE0468580, 0x1FB97A80, 0x0FBD7520, 0xF0462150, 0x00000000},	/* 118 */
  {0x0FFCC560, 0xE04625E0, 0x1FB9DA20, 0x0FBD78F0, 0xF045C190, 0x00000000},	/* 119 */
  {0x0FFD2140, 0xE045C680, 0x1FBA3980, 0x0FBD7C70, 0xF0456240, 0x00000000},	/* 120 */
  {0x0FFD7D30, 0xE04567A0, 0x1FBA9860, 0x0FBD7F60, 0xF0450360, 0x00000000},	/* 121 */
  {0x0FFDD8F0, 0xE0450980, 0x1FBAF680, 0x0FBD81D0, 0xF044A530, 0x00000000},	/* 122 */
  {0x0FFE34E0, 0xE044ABA0, 0x1FBB5460, 0x0FBD83D0, 0xF0444750, 0x00000000},	/* 123 */
  {0x0FFE9090, 0xE0444E80, 0x1FBBB180, 0x0FBD8530, 0xF043EA20, 0x00000000},	/* 124 */
  {0x0FFEEC90, 0xE043F180, 0x1FBC0E80, 0x0FBD8640, 0xF0438D30, 0x00000000},	/* 125 */
  {0x0FFF4840, 0xE0439540, 0x1FBC6AC0, 0x0FBD86B0, 0xF0433100, 0x00000000},	/* 126 */
  {0x0FFFA440, 0xE0433960, 0x1FBCC6A0, 0x0FBD86D0, 0xF042D510, 0x00000000},	/* 127 */
  {0x10000000, 0xE042DE20, 0x1FBD21E0, 0x0FBD8640, 0xF04279C0, 0x00000000},	/* 128 */
  {0x10005BC0, 0xE0428360, 0x1FBD7CA0, 0x0FBD8530, 0xF0421EF0, 0x00000000},	/* 129 */
  {0x1000B7C0, 0xE04228C0, 0x1FBDD740, 0x0FBD83C0, 0xF041C490, 0x00000000},	/* 130 */
  {0x10011380, 0xE041CF00, 0x1FBE3100, 0x0FBD81C0, 0xF0416AB0, 0x00000000},	/* 131 */
  {0x10016F80, 0xE0417580, 0x1FBE8A80, 0x0FBD7F60, 0xF0411130, 0x00000000},	/* 132 */
  {0x1001CB60, 0xE0411CA0, 0x1FBEE360, 0x0FBD7C60, 0xF040B850, 0x00000000},	/* 133 */
  {0x10022760, 0xE040C400, 0x1FBF3C00, 0x0FBD78F0, 0xF0405FD0, 0x00000000},	/* 134 */
  {0x10028320, 0xE0406C40, 0x1FBF93C0, 0x0FBD74F0, 0xF04007E0, 0x00000000},	/* 135 */
  {0x1002DF40, 0xE04014A0, 0x1FBFEB60, 0x0FBD7080, 0xF03FB040, 0x00000000},	/* 136 */
  {0x10033B40, 0xE03FBD80, 0x1FC04280, 0x0FBD6BA0, 0xF03F5930, 0x00000000},	/* 137 */
  {0x10039720, 0xE03F6700, 0x1FC09900, 0x0FBD6620, 0xF03F02A0, 0x00000000},	/* 138 */
  {0x1003F340, 0xE03F10E0, 0x1FC0EF20, 0x0FBD6030, 0xF03EAC80, 0x00000000},	/* 139 */
  {0x10044F40, 0xE03EBB40, 0x1FC144C0, 0x0FBD59C0, 0xF03E56D0, 0x00000000},	/* 140 */
  {0x1004ABA0, 0xE03E65C0, 0x1FC19A40, 0x0FBD5300, 0xF03E0180, 0x00000000},	/* 141 */
  {0x100507C0, 0xE03E1120, 0x1FC1EEE0, 0x0FBD4B90, 0xF03DACC0, 0x00000000},	/* 142 */
  {0x10056420, 0xE03DBCA0, 0x1FC24360, 0x0FBD43B0, 0xF03D5850, 0x00000000},	/* 143 */
  {0x1005C040, 0xE03D68E0, 0x1FC29720, 0x0FBD3B40, 0xF03D0480, 0x00000000},	/* 144 */
  {0x10061CA0, 0xE03D1560, 0x1FC2EAA0, 0x0FBD3260, 0xF03CB110, 0x00000000},	/* 145 */
  {0x10067900, 0xE03CC260, 0x1FC33DA0, 0x0FBD2900, 0xF03C5E00, 0x00000000},	/* 146 */
  {0x1006D560, 0xE03C6FE0, 0x1FC39020, 0x0FBD1F20, 0xF03C0B80, 0x00000000},	/* 147 */
  {0x100731E0, 0xE03C1DE0, 0x1FC3E220, 0x0FBD14B0, 0xF03BB960, 0x00000000},	/* 148 */
  {0x10078E80, 0xE03BCC00, 0x1FC43400, 0x0FBD09E0, 0xF03B67B0, 0x00000000},	/* 149 */
  {0x1007EB00, 0xE03B7AC0, 0x1FC48540, 0x0FBCFE90, 0xF03B1660, 0x00000000},	/* 150 */
  {0x100847C0, 0xE03B29E0, 0x1FC4D620, 0x0FBCF2C0, 0xF03AC580, 0x00000000},	/* 151 */
  {0x1008A480, 0xE03AD9A0, 0x1FC52660, 0x0FBCE650, 0xF03A7530, 0x00000000},	/* 152 */
  {0x10090160, 0xE03A8980, 0x1FC57680, 0x0FBCD980, 0xF03A2520, 0x00000000},	/* 153 */
  {0x10095E40, 0xE03A3A20, 0x1FC5C5E0, 0x0FBCCC10, 0xF039D5B0, 0x00000000},	/* 154 */
  {0x1009BB20, 0xE039EB00, 0x1FC61500, 0x0FBCBE40, 0xF0398690, 0x00000000},	/* 155 */
  {0x100A1860, 0xE0399C20, 0x1FC663E0, 0x0FBCB000, 0xF03937D0, 0x00000000},	/* 156 */
  {0x100A7560, 0xE0394E00, 0x1FC6B200, 0x0FBCA120, 0xF038E990, 0x00000000},	/* 157 */
  {0x100AD2A0, 0xE0390020, 0x1FC6FFE0, 0x0FBC91C0, 0xF0389BB0, 0x00000000},	/* 158 */
  {0x100B2FE0, 0xE038B2A0, 0x1FC74D60, 0x0FBC81E0, 0xF0384E40, 0x00000000},	/* 159 */
  {0x100B8D60, 0xE0386580, 0x1FC79A80, 0x0FBC71A0, 0xF0380120, 0x00000000},	/* 160 */
  {0x100BEAC0, 0xE0381900, 0x1FC7E700, 0x0FBC60A0, 0xF037B490, 0x00000000},	/* 161 */
  {0x100C4880, 0xE037CCA0, 0x1FC83360, 0x0FBC4F70, 0xF0376840, 0x00000000},	/* 162 */
  {0x100CA620, 0xE03780E0, 0x1FC87F20, 0x0FBC3D80, 0xF0371C70, 0x00000000},	/* 163 */
  {0x100D03C0, 0xE0373560, 0x1FC8CAA0, 0x0FBC2B30, 0xF036D0F0, 0x00000000},	/* 164 */
  {0x100D61A0, 0xE036EA60, 0x1FC915A0, 0x0FBC1850, 0xF0368600, 0x00000000},	/* 165 */
  {0x100DBFA0, 0xE0369FE0, 0x1FC96020, 0x0FBC04E0, 0xF0363B70, 0x00000000},	/* 166 */
  {0x100E1DC0, 0xE03655A0, 0x1FC9AA60, 0x0FBBF100, 0xF035F120, 0x00000000},	/* 167 */
  {0x100E7C00, 0xE0360BA0, 0x1FC9F460, 0x0FBBDCC0, 0xF035A740, 0x00000000},	/* 168 */
  {0x100EDA60, 0xE035C260, 0x1FCA3DA0, 0x0FBBC7C0, 0xF0355DE0, 0x00000000},	/* 169 */
  {0x100F38C0, 0xE0357960, 0x1FCA86A0, 0x0FBBB260, 0xF03514D0, 0x00000000},	/* 170 */
  {0x100F9760, 0xE0353080, 0x1FCACF80, 0x0FBB9C90, 0xF034CC10, 0x00000000},	/* 171 */
  {0x100FF620, 0xE034E840, 0x1FCB17C0, 0x0FBB8630, 0xF03483D0, 0x00000000},	/* 172 */
  {0x101054C0, 0xE034A060, 0x1FCB5FA0, 0x0FBB6F30, 0xF0343BF0, 0x00000000},	/* 173 */
  {0x1010B3E0, 0xE03458E0, 0x1FCBA720, 0x0FBB57D0, 0xF033F470, 0x00000000},	/* 174 */
  {0x101112E0, 0xE03411C0, 0x1FCBEE40, 0x0FBB3FE0, 0xF033AD40, 0x00000000},	/* 175 */
  {0x101171E0, 0xE033CB20, 0x1FCC34E0, 0x0FBB2760, 0xF03366A0, 0x00000000},	/* 176 */
  {0x1011D180, 0xE0338480, 0x1FCC7B80, 0x0FBB0E80, 0xF0332020, 0x00000000},	/* 177 */
  {0x101230C0, 0xE0333EA0, 0x1FCCC160, 0x0FBAF4F0, 0xF032DA30, 0x00000000},	/* 178 */
  {0x10129080, 0xE032F900, 0x1FCD0700, 0x0FBADB00, 0xF0329490, 0x00000000},	/* 179 */
  {0x1012F040, 0xE032B3A0, 0x1FCD4C60, 0x0FBAC090, 0xF0324F40, 0x00000000},	/* 180 */
  {0x10135020, 0xE0326EC0, 0x1FCD9140, 0x0FBAA590, 0xF0320A50, 0x00000000},	/* 181 */
  {0x1013B040, 0xE0322A60, 0x1FCDD5A0, 0x0FBA89F0, 0xF031C5E0, 0x00000000},	/* 182 */
  {0x10141060, 0xE031E640, 0x1FCE19C0, 0x0FBA6DF0, 0xF03181B0, 0x00000000},	/* 183 */
  {0x101470E0, 0xE031A240, 0x1FCE5DC0, 0x0FBA5170, 0xF0313DD0, 0x00000000},	/* 184 */
  {0x1014D160, 0xE0315EE0, 0x1FCEA120, 0x0FBA3450, 0xF030FA60, 0x00000000},	/* 185 */
  {0x101531E0, 0xE0311BE0, 0x1FCEE420, 0x0FBA16B0, 0xF030B760, 0x00000000},	/* 186 */
  {0x101592C0, 0xE030D940, 0x1FCF26C0, 0x0FB9F890, 0xF03074B0, 0x00000000},	/* 187 */
  {0x1015F3C0, 0xE03096C0, 0x1FCF6940, 0x0FB9D9F0, 0xF0303240, 0x00000000},	/* 188 */
  {0x10165500, 0xE03054C0, 0x1FCFAB40, 0x0FB9BAC0, 0xF02FF040, 0x00000000},	/* 189 */
  {0x1016B660, 0xE0301320, 0x1FCFECE0, 0x0FB99B20, 0xF02FAE90, 0x00000000},	/* 190 */
  {0x101717E0, 0xE02FD1E0, 0x1FD02E20, 0x0FB97AE0, 0xF02F6D50, 0x00000000},	/* 191 */
  {0x101779A0, 0xE02F90E0, 0x1FD06F20, 0x0FB95A30, 0xF02F2C50, 0x00000000},	/* 192 */
  {0x1017DB80, 0xE02F5020, 0x1FD0AFE0, 0x0FB93900, 0xF02EEBA0, 0x00000000},	/* 193 */
  {0x10183DA0, 0xE02F0FE0, 0x1FD0F020, 0x0FB91730, 0xF02EAB60, 0x00000000},	/* 194 */
  {0x10189FC0, 0xE02ED020, 0x1FD12FE0, 0x0FB8F4C0, 0xF02E6B70, 0x00000000},	/* 195 */
  {0x10190240, 0xE02E9040, 0x1FD16FC0, 0x0FB8D210, 0xF02E2BD0, 0x00000000},	/* 196 */
  {0x101964E0, 0xE02E5100, 0x1FD1AF00, 0x0FB8AEB0, 0xF02DEC90, 0x00000000},	/* 197 */
  {0x1019C7A0, 0xE02E1240, 0x1FD1EDC0, 0x0FB88AB0, 0xF02DADB0, 0x00000000},	/* 198 */
  {0x101A2AA0, 0xE02DD3C0, 0x1FD22C40, 0x0FB86640, 0xF02D6F20, 0x00000000},	/* 199 */
  {0x101A8DE0, 0xE02D9560, 0x1FD26AA0, 0x0FB84150, 0xF02D30D0, 0x00000000},	/* 200 */
  {0x101AF140, 0xE02D57A0, 0x1FD2A860, 0x0FB81BC0, 0xF02CF2F0, 0x00000000},	/* 201 */
  {0x101B5500, 0xE02D19C0, 0x1FD2E640, 0x0FB7F5D0, 0xF02CB540, 0x00000000},	/* 202 */
  {0x101BB8C0, 0xE02CDCC0, 0x1FD32340, 0x0FB7CF30, 0xF02C7810, 0x00000000},	/* 203 */
  {0x101C1CC0, 0xE02C9FA0, 0x1FD36060, 0x0FB7A830, 0xF02C3B20, 0x00000000},	/* 204 */
  {0x101C8120, 0xE02C6300, 0x1FD39D00, 0x0FB78070, 0xF02BFE70, 0x00000000},	/* 205 */
  {0x101CE5A0, 0xE02C26A0, 0x1FD3D960, 0x0FB75850, 0xF02BC220, 0x00000000},	/* 206 */
  {0x101D4A40, 0xE02BEAE0, 0x1FD41520, 0x0FB72F80, 0xF02B8640, 0x00000000},	/* 207 */
  {0x101DAF20, 0xE02BAF40, 0x1FD450C0, 0x0FB70640, 0xF02B4AA0, 0x00000000},	/* 208 */
  {0x101E1440, 0xE02B73E0, 0x1FD48C20, 0x0FB6DC70, 0xF02B0F40, 0x00000000},	/* 209 */
  {0x101E79C0, 0xE02B38C0, 0x1FD4C740, 0x0FB6B220, 0xF02AD430, 0x00000000},	/* 210 */
  {0x101EDF40, 0xE02AFE20, 0x1FD501E0, 0x0FB68730, 0xF02A9980, 0x00000000},	/* 211 */
  {0x101F4520, 0xE02AC3C0, 0x1FD53C40, 0x0FB65BB0, 0xF02A5F20, 0x00000000},	/* 212 */
  {0x101FAB60, 0xE02A89A0, 0x1FD57660, 0x0FB62FC0, 0xF02A2500, 0x00000000},	/* 213 */
  {0x10201180, 0xE02A4FE0, 0x1FD5B020, 0x0FB60330, 0xF029EB50, 0x00000000},	/* 214 */
  {0x10207820, 0xE02A1680, 0x1FD5E980, 0x0FB5D600, 0xF029B1D0, 0x00000000},	/* 215 */
  {0x1020DEE0, 0xE029DD60, 0x1FD622A0, 0x0FB5A860, 0xF02978B0, 0x00000000},	/* 216 */
  {0x10214600, 0xE029A460, 0x1FD65BA0, 0x0FB57A30, 0xF0293FD0, 0x00000000},	/* 217 */
  {0x1021AD60, 0xE0296BC0, 0x1FD69440, 0x0FB54B80, 0xF0290730, 0x00000000},	/* 218 */
  {0x10221500, 0xE02933A0, 0x1FD6CC60, 0x0FB51C30, 0xF028CEF0, 0x00000000},	/* 219 */
  {0x10227CC0, 0xE028FBA0, 0x1FD70460, 0x0FB4EC40, 0xF0289700, 0x00000000},	/* 220 */
  {0x1022E4E0, 0xE028C400, 0x1FD73C00, 0x0FB4BBE0, 0xF0285F60, 0x00000000},	/* 221 */
  {0x10234D20, 0xE0288CC0, 0x1FD77340, 0x0FB48AD0, 0xF0282810, 0x00000000},	/* 222 */
  {0x1023B5E0, 0xE0285580, 0x1FD7AA80, 0x0FB45940, 0xF027F0F0, 0x00000000},	/* 223 */
  {0x10241EC0, 0xE0281EE0, 0x1FD7E120, 0x0FB42720, 0xF027BA30, 0x00000000},	/* 224 */
  {0x102487C0, 0xE027E860, 0x1FD817A0, 0x0FB3F470, 0xF02783C0, 0x00000000},	/* 225 */
  {0x1024F140, 0xE027B220, 0x1FD84DE0, 0x0FB3C130, 0xF0274D90, 0x00000000},	/* 226 */
  {0x10255B00, 0xE0277C60, 0x1FD883A0, 0x0FB38D40, 0xF02717B0, 0x00000000},	/* 227 */
  {0x1025C500, 0xE02746A0, 0x1FD8B960, 0x0FB358F0, 0xF026E200, 0x00000000},	/* 228 */
  {0x10262F40, 0xE0271160, 0x1FD8EEA0, 0x0FB323F0, 0xF026ACD0, 0x00000000},	/* 229 */
  {0x102699E0, 0xE026DC80, 0x1FD92380, 0x0FB2EE60, 0xF02677C0, 0x00000000},	/* 230 */
  {0x102704C0, 0xE026A7C0, 0x1FD95840, 0x0FB2B840, 0xF0264300, 0x00000000},	/* 231 */
  {0x10276FE0, 0xE0267320, 0x1FD98CE0, 0x0FB28190, 0xF0260E80, 0x00000000},	/* 232 */
  {0x1027DB60, 0xE0263EE0, 0x1FD9C120, 0x0FB24A60, 0xF025DA40, 0x00000000},	/* 233 */
  {0x10284740, 0xE0260AE0, 0x1FD9F520, 0x0FB21290, 0xF025A650, 0x00000000},	/* 234 */
  {0x1028B340, 0xE025D760, 0x1FDA28A0, 0x0FB1DA10, 0xF02572C0, 0x00000000},	/* 235 */
  {0x10291F80, 0xE025A420, 0x1FDA5BE0, 0x0FB1A100, 0xF0253F60, 0x00000000},	/* 236 */
  {0x10298C40, 0xE02570E0, 0x1FDA8F20, 0x0FB16780, 0xF0250C40, 0x00000000},	/* 237 */
  {0x1029F960, 0xE0253E00, 0x1FDAC200, 0x0FB12D50, 0xF024D970, 0x00000000},	/* 238 */
  {0x102A66A0, 0xE0250B80, 0x1FDAF480, 0x0FB0F280, 0xF024A6E0, 0x00000000},	/* 239 */
  {0x102AD440, 0xE024D940, 0x1FDB26C0, 0x0FB0B730, 0xF02474A0, 0x00000000},	/* 240 */
  {0x102B4220, 0xE024A760, 0x1FDB58A0, 0x0FB07B20, 0xF02442B0, 0x00000000},	/* 241 */
  {0x102BB060, 0xE02475A0, 0x1FDB8A60, 0x0FB03EA0, 0xF02410F0, 0x00000000},	/* 242 */
  {0x102C1F40, 0xE0244400, 0x1FDBBC00, 0x0FB00180, 0xF023DF60, 0x00000000},	/* 243 */
  {0x102C8E00, 0xE0241300, 0x1FDBED00, 0x0FAFC3B0, 0xF023AE40, 0x00000000},	/* 244 */
  {0x102CFD60, 0xE023E1E0, 0x1FDC1E20, 0x0FAF8560, 0xF0237D40, 0x00000000},	/* 245 */
  {0x102D6CE0, 0xE023B160, 0x1FDC4EA0, 0x0FAF4670, 0xF0234C90, 0x00000000},	/* 246 */
  {0x102DDD00, 0xE02380C0, 0x1FDC7F40, 0x0FAF0700, 0xF0231C20, 0x00000000},	/* 247 */
  {0x102E4D40, 0xE02350A0, 0x1FDCAF60, 0x0FAEC6C0, 0xF022EC00, 0x00000000},	/* 248 */
  {0x102EBDE0, 0xE02320E0, 0x1FDCDF20, 0x0FAE8600, 0xF022BC10, 0x00000000},	/* 249 */
  {0x102F2F00, 0xE022F100, 0x1FDD0F00, 0x0FAE44C0, 0xF0228C60, 0x00000000},	/* 250 */
  {0x102FA040, 0xE022C1A0, 0x1FDD3E60, 0x0FAE02C0, 0xF0225CF0, 0x00000000},	/* 251 */
  {0x10301220, 0xE0229280, 0x1FDD6D80, 0x0FADC020, 0xF0222DD0, 0x00000000},	/* 252 */
  {0x10308420, 0xE02263C0, 0x1FDD9C40, 0x0FAD7CE0, 0xF021FF00, 0x00000000},	/* 253 */
  {0x1030F680, 0xE0223520, 0x1FDDCAE0, 0x0FAD3910, 0xF021D050, 0x00000000},	/* 254 */
  {0x10316960, 0xE02206C0, 0x1FDDF940, 0x0FACF4A0, 0xF021A1F0, 0x00000000},	/* 255 */
  {0x1031DCA0, 0xE021D860, 0x1FDE27A0, 0x0FACAFB0, 0xF02173B0, 0x00000000},	/* 256 */
  {0, 0, 0, 0, 0, 0}
};

static const unsigned int eq_band2_data[][6] = {
  {0x0E210CA0, 0xE52A2D20, 0x1AD5D2E0, 0x0CDFB8A0, 0xF4FF3AC0, 0x00000000},	/* 0 */
  {0x0E24F640, 0xE52465C0, 0x1ADB9A40, 0x0CE19F90, 0xF4F96A30, 0x00000000},	/* 1 */
  {0x0E28DE90, 0xE51EA3E0, 0x1AE15C20, 0x0CE38250, 0xF4F39F20, 0x00000000},	/* 2 */
  {0x0E2CC590, 0xE518E7A0, 0x1AE71860, 0x0CE560D0, 0xF4EDD990, 0x00000000},	/* 3 */
  {0x0E30AB40, 0xE51330C0, 0x1AECCF40, 0x0CE73B20, 0xF4E81990, 0x00000000},	/* 4 */
  {0x0E348FD0, 0xE50D7F20, 0x1AF280E0, 0x0CE91130, 0xF4E25F00, 0x00000000},	/* 5 */
  {0x0E387300, 0xE507D340, 0x1AF82CC0, 0x0CEAE310, 0xF4DCAA00, 0x00000000},	/* 6 */
  {0x0E3C5500, 0xE5022CC0, 0x1AFDD340, 0x0CECB0B0, 0xF4D6FA60, 0x00000000},	/* 7 */
  {0x0E4035B0, 0xE4FC8BA0, 0x1B037460, 0x0CEE7A00, 0xF4D15050, 0x00000000},	/* 8 */
  {0x0E441530, 0xE4F6F000, 0x1B091000, 0x0CF03F30, 0xF4CBABA0, 0x00000000},	/* 9 */
  {0x0E47F380, 0xE4F159C0, 0x1B0EA640, 0x0CF20020, 0xF4C60C80, 0x00000000},	/* 10 */
  {0x0E4BD090, 0xE4EBC8E0, 0x1B143720, 0x0CF3BCC0, 0xF4C072C0, 0x00000000},	/* 11 */
  {0x0E4FAC70, 0xE4E63D80, 0x1B19C280, 0x0CF57530, 0xF4BADE70, 0x00000000},	/* 12 */
  {0x0E538720, 0xE4E0B760, 0x1B1F48A0, 0x0CF72950, 0xF4B54F80, 0x00000000},	/* 13 */
  {0x0E5760D0, 0xE4DB36C0, 0x1B24C940, 0x0CF8D940, 0xF4AFC600, 0x00000000},	/* 14 */
  {0x0E5B3920, 0xE4D5BB60, 0x1B2A44A0, 0x0CFA84E0, 0xF4AA41E0, 0x00000000},	/* 15 */
  {0x0E5F1070, 0xE4D04580, 0x1B2FBA80, 0x0CFC2C50, 0xF4A4C340, 0x00000000},	/* 16 */
  {0x0E62E690, 0xE4CAD4C0, 0x1B352B40, 0x0CFDCF80, 0xF49F49F0, 0x00000000},	/* 17 */
  {0x0E66BBA0, 0xE4C569A0, 0x1B3A9660, 0x0CFF6E60, 0xF499D5F0, 0x00000000},	/* 18 */
  {0x0E6A8FC0, 0xE4C00380, 0x1B3FFC80, 0x0D010900, 0xF4946750, 0x00000000},	/* 19 */
  {0x0E6E6290, 0xE4BAA2E0, 0x1B455D20, 0x0D029F60, 0xF48EFE10, 0x00000000},	/* 20 */
  {0x0E723470, 0xE4B54780, 0x1B4AB880, 0x0D043170, 0xF4899A20, 0x00000000},	/* 21 */
  {0x0E760530, 0xE4AFF1A0, 0x1B500E60, 0x0D05BF30, 0xF4843BA0, 0x00000000},	/* 22 */
  {0x0E79D4F0, 0xE4AAA0C0, 0x1B555F40, 0x0D0748C0, 0xF47EE240, 0x00000000},	/* 23 */
  {0x0E7DA3C0, 0xE4A55520, 0x1B5AAAE0, 0x0D08CE10, 0xF4798E50, 0x00000000},	/* 24 */
  {0x0E817160, 0xE4A00F20, 0x1B5FF0E0, 0x0D0A4EE0, 0xF4743FB0, 0x00000000},	/* 25 */
  {0x0E853E30, 0xE49ACE00, 0x1B653200, 0x0D0BCBA0, 0xF46EF630, 0x00000000},	/* 26 */
  {0x0E8909D0, 0xE4959240, 0x1B6A6DC0, 0x0D0D4400, 0xF469B220, 0x00000000},	/* 27 */
  {0x0E8CD4A0, 0xE4905BC0, 0x1B6FA440, 0x0D0EB820, 0xF4647340, 0x00000000},	/* 28 */
  {0x0E909E80, 0xE48B2A80, 0x1B74D580, 0x0D1027E0, 0xF45F3990, 0x00000000},	/* 29 */
  {0x0E946770, 0xE485FE40, 0x1B7A01C0, 0x0D119370, 0xF45A0530, 0x00000000},	/* 30 */
  {0x0E982F70, 0xE480D760, 0x1B7F28A0, 0x0D12FA90, 0xF454D600, 0x00000000},	/* 31 */
  {0x0E9BF680, 0xE47BB580, 0x1B844A80, 0x0D145D80, 0xF44FAC10, 0x00000000},	/* 32 */
  {0x0E9FBCA0, 0xE4769920, 0x1B8966E0, 0x0D15BC00, 0xF44A8760, 0x00000000},	/* 33 */
  {0x0EA381E0, 0xE47181C0, 0x1B8E7E40, 0x0D171640, 0xF44567C0, 0x00000000},	/* 34 */
  {0x0EA74660, 0xE46C6F40, 0x1B9390C0, 0x0D186C50, 0xF4404D60, 0x00000000},	/* 35 */
  {0x0EAB0A10, 0xE4676220, 0x1B989DE0, 0x0D19BDE0, 0xF43B3820, 0x00000000},	/* 36 */
  {0x0EAECCB0, 0xE4625A40, 0x1B9DA5C0, 0x0D1B0B20, 0xF4362810, 0x00000000},	/* 37 */
  {0x0EB28EC0, 0xE45D5740, 0x1BA2A8C0, 0x0D1C5420, 0xF4311D20, 0x00000000},	/* 38 */
  {0x0EB64FE0, 0xE4585980, 0x1BA7A680, 0x0D1D98D0, 0xF42C1760, 0x00000000},	/* 39 */
  {0x0EBA1030, 0xE45360C0, 0x1BAC9F40, 0x0D1ED910, 0xF42716B0, 0x00000000},	/* 40 */
  {0x0EBDCFE0, 0xE44E6D20, 0x1BB192E0, 0x0D201510, 0xF4221B20, 0x00000000},	/* 41 */
  {0x0EC18EA0, 0xE4497EA0, 0x1BB68160, 0x0D214CA0, 0xF41D24B0, 0x00000000},	/* 42 */
  {0x0EC54CD0, 0xE4449500, 0x1BBB6B00, 0x0D228000, 0xF4183340, 0x00000000},	/* 43 */
  {0x0EC90A20, 0xE43FB0A0, 0x1BC04F60, 0x0D23AED0, 0xF4134700, 0x00000000},	/* 44 */
  {0x0ECCC6D0, 0xE43AD120, 0x1BC52EE0, 0x0D24D970, 0xF40E5FC0, 0x00000000},	/* 45 */
  {0x0ED082E0, 0xE435F6A0, 0x1BCA0960, 0x0D25FFB0, 0xF4097D80, 0x00000000},	/* 46 */
  {0x0ED43E10, 0xE4312140, 0x1BCEDEC0, 0x0D272190, 0xF404A050, 0x00000000},	/* 47 */
  {0x0ED7F8D0, 0xE42C50C0, 0x1BD3AF40, 0x0D283F10, 0xF3FFC830, 0x00000000},	/* 48 */
  {0x0EDBB2C0, 0xE4278560, 0x1BD87AA0, 0x0D295830, 0xF3FAF510, 0x00000000},	/* 49 */
  {0x0EDF6C20, 0xE422BEC0, 0x1BDD4140, 0x0D2A6D00, 0xF3F626E0, 0x00000000},	/* 50 */
  {0x0EE324F0, 0xE41DFD40, 0x1BE202C0, 0x0D2B7D60, 0xF3F15DB0, 0x00000000},	/* 51 */
  {0x0EE6DCF0, 0xE41940C0, 0x1BE6BF40, 0x0D2C8960, 0xF3EC99A0, 0x00000000},	/* 52 */
  {0x0EEA94A0, 0xE4148900, 0x1BEB7700, 0x0D2D9110, 0xF3E7DA50, 0x00000000},	/* 53 */
  {0x0EEE4BB0, 0xE40FD620, 0x1BF029E0, 0x0D2E9460, 0xF3E32010, 0x00000000},	/* 54 */
  {0x0EF20220, 0xE40B2880, 0x1BF4D780, 0x0D2F9320, 0xF3DE6AC0, 0x00000000},	/* 55 */
  {0x0EF5B820, 0xE4067F60, 0x1BF980A0, 0x0D308DB0, 0xF3D9BA40, 0x00000000},	/* 56 */
  {0x0EF96D70, 0xE401DB60, 0x1BFE24A0, 0x0D3183C0, 0xF3D50ED0, 0x00000000},	/* 57 */
  {0x0EFD2270, 0xE3FD3C20, 0x1C02C3E0, 0x0D327570, 0xF3D06820, 0x00000000},	/* 58 */
  {0x0F00D6E0, 0xE3F8A1E0, 0x1C075E20, 0x0D3362B0, 0xF3CBC670, 0x00000000},	/* 59 */
  {0x0F048AE0, 0xE3F40C40, 0x1C0BF3C0, 0x0D344B90, 0xF3C72990, 0x00000000},	/* 60 */
  {0x0F083E70, 0xE3EF7B80, 0x1C108480, 0x0D353010, 0xF3C29190, 0x00000000},	/* 61 */
  {0x0F0BF180, 0xE3EAEFC0, 0x1C151040, 0x0D361000, 0xF3BDFE60, 0x00000000},	/* 62 */
  {0x0F0FA440, 0xE3E668A0, 0x1C199760, 0x0D36EBA0, 0xF3B97010, 0x00000000},	/* 63 */
  {0x0F135680, 0xE3E1E640, 0x1C1E19C0, 0x0D37C2E0, 0xF3B4E690, 0x00000000},	/* 64 */
  {0x0F170890, 0xE3DD68C0, 0x1C229740, 0x0D3895B0, 0xF3B061E0, 0x00000000},	/* 65 */
  {0x0F1ABA10, 0xE3D8F000, 0x1C271000, 0x0D396400, 0xF3ABE1F0, 0x00000000},	/* 66 */
  {0x0F1E6B40, 0xE3D47C00, 0x1C2B8400, 0x0D3A2DE0, 0xF3A766E0, 0x00000000},	/* 67 */
  {0x0F221C30, 0xE3D00CC0, 0x1C2FF340, 0x0D3AF360, 0xF3A2F080, 0x00000000},	/* 68 */
  {0x0F25CCE0, 0xE3CBA220, 0x1C345DE0, 0x0D3BB460, 0xF39E7ED0, 0x00000000},	/* 69 */
  {0x0F297D30, 0xE3C73C60, 0x1C38C3A0, 0x0D3C70F0, 0xF39A1200, 0x00000000},	/* 70 */
  {0x0F2D2D20, 0xE3C2DB40, 0x1C3D24C0, 0x0D3D28F0, 0xF395A9E0, 0x00000000},	/* 71 */
  {0x0F30DD00, 0xE3BE7EC0, 0x1C418140, 0x0D3DDCA0, 0xF3914660, 0x00000000},	/* 72 */
  {0x0F348C70, 0xE3BA2700, 0x1C45D900, 0x0D3E8BD0, 0xF38CE7A0, 0x00000000},	/* 73 */
  {0x0F383BC0, 0xE3B5D3E0, 0x1C4A2C20, 0x0D3F3680, 0xF3888DB0, 0x00000000},	/* 74 */
  {0x0F3BEAF0, 0xE3B18580, 0x1C4E7A80, 0x0D3FDCC0, 0xF3843850, 0x00000000},	/* 75 */
  {0x0F3F99E0, 0xE3AD3BA0, 0x1C52C460, 0x0D407E80, 0xF37FE7A0, 0x00000000},	/* 76 */
  {0x0F4348B0, 0xE3A8F660, 0x1C5709A0, 0x0D411BD0, 0xF37B9B90, 0x00000000},	/* 77 */
  {0x0F46F750, 0xE3A4B5C0, 0x1C5B4A40, 0x0D41B490, 0xF3775420, 0x00000000},	/* 78 */
  {0x0F4AA5E0, 0xE3A079A0, 0x1C5F8660, 0x0D4248F0, 0xF3731150, 0x00000000},	/* 79 */
  {0x0F4E5430, 0xE39C4260, 0x1C63BDA0, 0x0D42D8A0, 0xF36ED330, 0x00000000},	/* 80 */
  {0x0F520280, 0xE3980F60, 0x1C67F0A0, 0x0D436400, 0xF36A9980, 0x00000000},	/* 81 */
  {0x0F55B0B0, 0xE393E120, 0x1C6C1EE0, 0x0D43EAB0, 0xF3666480, 0x00000000},	/* 82 */
  {0x0F595F00, 0xE38FB740, 0x1C7048C0, 0x0D446D10, 0xF3623410, 0x00000000},	/* 83 */
  {0x0F5D0D10, 0xE38B9200, 0x1C746E00, 0x0D44EAC0, 0xF35E0830, 0x00000000},	/* 84 */
  {0x0F60BB40, 0xE3877140, 0x1C788EC0, 0x0D456400, 0xF359E0D0, 0x00000000},	/* 85 */
  {0x0F646950, 0xE3835500, 0x1C7CAB00, 0x0D45D8C0, 0xF355BE00, 0x00000000},	/* 86 */
  {0x0F681760, 0xE37F3D60, 0x1C80C2A0, 0x0D4648D0, 0xF3519FB0, 0x00000000},	/* 87 */
  {0x0F6BC5B0, 0xE37B2A00, 0x1C84D600, 0x0D46B480, 0xF34D85E0, 0x00000000},	/* 88 */
  {0x0F6F73E0, 0xE3771B20, 0x1C88E4E0, 0x0D471B90, 0xF3497090, 0x00000000},	/* 89 */
  {0x0F732220, 0xE37310E0, 0x1C8CEF20, 0x0D477E10, 0xF3455FB0, 0x00000000},	/* 90 */
  {0x0F76D0B0, 0xE36F0AC0, 0x1C90F540, 0x0D47DC10, 0xF3415340, 0x00000000},	/* 91 */
  {0x0F7A7F40, 0xE36B0940, 0x1C94F6C0, 0x0D483580, 0xF33D4B60, 0x00000000},	/* 92 */
  {0x0F7E2DD0, 0xE3670C20, 0x1C98F3E0, 0x0D488A50, 0xF33947D0, 0x00000000},	/* 93 */
  {0x0F81DCB0, 0xE3631360, 0x1C9CECA0, 0x0D48DA90, 0xF33548C0, 0x00000000},	/* 94 */
  {0x0F858BB0, 0xE35F1F00, 0x1CA0E100, 0x0D492650, 0xF3314E10, 0x00000000},	/* 95 */
  {0x0F893AD0, 0xE35B2F20, 0x1CA4D0E0, 0x0D496D60, 0xF32D57D0, 0x00000000},	/* 96 */
  {0x0F8CEA50, 0xE3574360, 0x1CA8BCA0, 0x0D49AFF0, 0xF32965D0, 0x00000000},	/* 97 */
  {0x0F9099E0, 0xE3535C20, 0x1CACA3E0, 0x0D49EDE0, 0xF3257840, 0x00000000},	/* 98 */
  {0x0F9449D0, 0xE34F7920, 0x1CB086E0, 0x0D4A2720, 0xF3218F10, 0x00000000},	/* 99 */
  {0x0F97F9F0, 0xE34B9A60, 0x1CB465A0, 0x0D4A5BE0, 0xF31DAA30, 0x00000000},	/* 100 */
  {0x0F9BAA70, 0xE347C020, 0x1CB83FE0, 0x0D4A8BF0, 0xF319C9A0, 0x00000000},	/* 101 */
  {0x0F9F5B40, 0xE343E9E0, 0x1CBC1620, 0x0D4AB770, 0xF315ED60, 0x00000000},	/* 102 */
  {0x0FA30C60, 0xE3401800, 0x1CBFE800, 0x0D4ADE50, 0xF3121570, 0x00000000},	/* 103 */
  {0x0FA6BDB0, 0xE33C4A80, 0x1CC3B580, 0x0D4B0080, 0xF30E41C0, 0x00000000},	/* 104 */
  {0x0FAA6F90, 0xE3388140, 0x1CC77EC0, 0x0D4B1E00, 0xF30A7260, 0x00000000},	/* 105 */
  {0x0FAE21B0, 0xE334BC20, 0x1CCB43E0, 0x0D4B3700, 0xF306A740, 0x00000000},	/* 106 */
  {0x0FB1D460, 0xE330FB40, 0x1CCF04C0, 0x0D4B4B40, 0xF302E060, 0x00000000},	/* 107 */
  {0x0FB58770, 0xE32D3E80, 0x1CD2C180, 0x0D4B5AE0, 0xF2FF1DB0, 0x00000000},	/* 108 */
  {0x0FB93B00, 0xE3298600, 0x1CD67A00, 0x0D4B65D0, 0xF2FB5F30, 0x00000000},	/* 109 */
  {0x0FBCEEF0, 0xE325D1C0, 0x1CDA2E40, 0x0D4B6C10, 0xF2F7A4F0, 0x00000000},	/* 110 */
  {0x0FC0A390, 0xE3222180, 0x1CDDDE80, 0x0D4B6DB0, 0xF2F3EED0, 0x00000000},	/* 111 */
  {0x0FC45880, 0xE31E7560, 0x1CE18AA0, 0x0D4B6A90, 0xF2F03CF0, 0x00000000},	/* 112 */
  {0x0FC80E10, 0xE31ACD80, 0x1CE53280, 0x0D4B62D0, 0xF2EC8F30, 0x00000000},	/* 113 */
  {0x0FCBC420, 0xE31729C0, 0x1CE8D640, 0x0D4B5640, 0xF2E8E5A0, 0x00000000},	/* 114 */
  {0x0FCF7AE0, 0xE3138A20, 0x1CEC75E0, 0x0D4B4510, 0xF2E54020, 0x00000000},	/* 115 */
  {0x0FD33210, 0xE30FEE80, 0x1CF01180, 0x0D4B2F20, 0xF2E19EC0, 0x00000000},	/* 116 */
  {0x0FD6E9F0, 0xE30C5700, 0x1CF3A900, 0x0D4B1470, 0xF2DE0180, 0x00000000},	/* 117 */
  {0x0FDAA2A0, 0xE308C380, 0x1CF73C80, 0x0D4AF520, 0xF2DA6860, 0x00000000},	/* 118 */
  {0x0FDE5BC0, 0xE3053440, 0x1CFACBC0, 0x0D4AD0F0, 0xF2D6D340, 0x00000000},	/* 119 */
  {0x0FE215A0, 0xE301A8E0, 0x1CFE5720, 0x0D4AA820, 0xF2D34240, 0x00000000},	/* 120 */
  {0x0FE5D030, 0xE2FE2180, 0x1D01DE80, 0x0D4A7A70, 0xF2CFB550, 0x00000000},	/* 121 */
  {0x0FE98B90, 0xE2FA9E20, 0x1D0561E0, 0x0D4A4820, 0xF2CC2C40, 0x00000000},	/* 122 */
  {0x0FED47A0, 0xE2F71EE0, 0x1D08E120, 0x0D4A1100, 0xF2C8A760, 0x00000000},	/* 123 */
  {0x0FF10480, 0xE2F3A380, 0x1D0C5C80, 0x0D49D510, 0xF2C52670, 0x00000000},	/* 124 */
  {0x0FF4C220, 0xE2F02C00, 0x1D0FD400, 0x0D499460, 0xF2C1A990, 0x00000000},	/* 125 */
  {0x0FF88090, 0xE2ECB8C0, 0x1D134740, 0x0D494ED0, 0xF2BE30A0, 0x00000000},	/* 126 */
  {0x0FFC3FD0, 0xE2E94940, 0x1D16B6C0, 0x0D490480, 0xF2BABBB0, 0x00000000},	/* 127 */
  {0x10000000, 0xE2E5DDC0, 0x1D1A2240, 0x0D48B550, 0xF2B74AB0, 0x00000000},	/* 128 */
  {0x1003C120, 0xE2E27600, 0x1D1D8A00, 0x0D486170, 0xF2B3DD80, 0x00000000},	/* 129 */
  {0x10078300, 0xE2DF1260, 0x1D20EDA0, 0x0D4808A0, 0xF2B07460, 0x00000000},	/* 130 */
  {0x100B45C0, 0xE2DBB260, 0x1D244DA0, 0x0D47AB10, 0xF2AD0F10, 0x00000000},	/* 131 */
  {0x100F09A0, 0xE2D85680, 0x1D27A980, 0x0D4748A0, 0xF2A9ADC0, 0x00000000},	/* 132 */
  {0x1012CE60, 0xE2D4FE60, 0x1D2B01A0, 0x0D46E150, 0xF2A65050, 0x00000000},	/* 133 */
  {0x10169420, 0xE2D1AA00, 0x1D2E5600, 0x0D467530, 0xF2A2F6B0, 0x00000000},	/* 134 */
  {0x101A5B00, 0xE2CE59A0, 0x1D31A660, 0x0D460420, 0xF29FA100, 0x00000000},	/* 135 */
  {0x101E22C0, 0xE2CB0D00, 0x1D34F300, 0x0D458E40, 0xF29C4F10, 0x00000000},	/* 136 */
  {0x1021EBA0, 0xE2C7C440, 0x1D383BC0, 0x0D451370, 0xF2990100, 0x00000000},	/* 137 */
  {0x1025B580, 0xE2C47F40, 0x1D3B80C0, 0x0D4493C0, 0xF295B6D0, 0x00000000},	/* 138 */
  {0x102980A0, 0xE2C13DE0, 0x1D3EC220, 0x0D440F30, 0xF2927040, 0x00000000},	/* 139 */
  {0x102D4CC0, 0xE2BE0060, 0x1D41FFA0, 0x0D4385B0, 0xF28F2DA0, 0x00000000},	/* 140 */
  {0x10311A00, 0xE2BAC6E0, 0x1D453920, 0x0D42F720, 0xF28BEED0, 0x00000000},	/* 141 */
  {0x1034E8A0, 0xE2B790E0, 0x1D486F20, 0x0D4263C0, 0xF288B3B0, 0x00000000},	/* 142 */
  {0x1038B840, 0xE2B45E80, 0x1D4BA180, 0x0D41CB70, 0xF2857C40, 0x00000000},	/* 143 */
  {0x103C8920, 0xE2B13020, 0x1D4ECFE0, 0x0D412E20, 0xF28248B0, 0x00000000},	/* 144 */
  {0x10405B40, 0xE2AE0540, 0x1D51FAC0, 0x0D408BE0, 0xF27F18C0, 0x00000000},	/* 145 */
  {0x10442EE0, 0xE2AADDE0, 0x1D552220, 0x0D3FE4C0, 0xF27BEC70, 0x00000000},	/* 146 */
  {0x10480380, 0xE2A7BA60, 0x1D5845A0, 0x0D3F3890, 0xF278C3F0, 0x00000000},	/* 147 */
  {0x104BD9A0, 0xE2A49AA0, 0x1D5B6560, 0x0D3E8750, 0xF2759F20, 0x00000000},	/* 148 */
  {0x104FB100, 0xE2A17E60, 0x1D5E81A0, 0x0D3DD120, 0xF2727DF0, 0x00000000},	/* 149 */
  {0x105389A0, 0xE29E6600, 0x1D619A00, 0x0D3D15D0, 0xF26F6080, 0x00000000},	/* 150 */
  {0x105763C0, 0xE29B5100, 0x1D64AF00, 0x0D3C55A0, 0xF26C46A0, 0x00000000},	/* 151 */
  {0x105B3F60, 0xE2983F80, 0x1D67C080, 0x0D3B9060, 0xF2693050, 0x00000000},	/* 152 */
  {0x105F1C20, 0xE2953200, 0x1D6ACE00, 0x0D3AC5F0, 0xF2661DC0, 0x00000000},	/* 153 */
  {0x1062FAA0, 0xE29227C0, 0x1D6DD840, 0x0D39F6A0, 0xF2630EC0, 0x00000000},	/* 154 */
  {0x1066DA80, 0xE28F2140, 0x1D70DEC0, 0x0D392230, 0xF2600340, 0x00000000},	/* 155 */
  {0x106ABC00, 0xE28C1E20, 0x1D73E1E0, 0x0D3848B0, 0xF25CFB60, 0x00000000},	/* 156 */
  {0x106E9EE0, 0xE2891EA0, 0x1D76E160, 0x0D376A00, 0xF259F710, 0x00000000},	/* 157 */
  {0x10728360, 0xE2862280, 0x1D79DD80, 0x0D368650, 0xF256F640, 0x00000000},	/* 158 */
  {0x10766960, 0xE2832A20, 0x1D7CD5E0, 0x0D359D70, 0xF253F910, 0x00000000},	/* 159 */
  {0x107A5140, 0xE2803500, 0x1D7FCB00, 0x0D34AF90, 0xF250FF60, 0x00000000},	/* 160 */
  {0x107E3A60, 0xE27D43A0, 0x1D82BC60, 0x0D33BC70, 0xF24E0920, 0x00000000},	/* 161 */
  {0x10822560, 0xE27A55A0, 0x1D85AA60, 0x0D32C430, 0xF24B1680, 0x00000000},	/* 162 */
  {0x10861200, 0xE2776B00, 0x1D889500, 0x0D31C6D0, 0xF2482730, 0x00000000},	/* 163 */
  {0x108A0040, 0xE2748400, 0x1D8B7C00, 0x0D30C430, 0xF2453B80, 0x00000000},	/* 164 */
  {0x108DF060, 0xE271A040, 0x1D8E5FC0, 0x0D2FBC70, 0xF2425330, 0x00000000},	/* 165 */
  {0x1091E240, 0xE26EBFE0, 0x1D914020, 0x0D2EAF90, 0xF23F6E50, 0x00000000},	/* 166 */
  {0x1095D5C0, 0xE26BE320, 0x1D941CE0, 0x0D2D9D60, 0xF23C8CE0, 0x00000000},	/* 167 */
  {0x1099CB20, 0xE26909C0, 0x1D96F640, 0x0D2C8600, 0xF239AEF0, 0x00000000},	/* 168 */
  {0x109DC260, 0xE2663380, 0x1D99CC80, 0x0D2B6970, 0xF236D440, 0x00000000},	/* 169 */
  {0x10A1BB60, 0xE26360E0, 0x1D9C9F20, 0x0D2A4790, 0xF233FD00, 0x00000000},	/* 170 */
  {0x10A5B660, 0xE2609180, 0x1D9F6E80, 0x0D292070, 0xF2312930, 0x00000000},	/* 171 */
  {0x10A9B340, 0xE25DC5A0, 0x1DA23A60, 0x0D27F410, 0xF22E58B0, 0x00000000},	/* 172 */
  {0x10ADB1E0, 0xE25AFD00, 0x1DA50300, 0x0D26C260, 0xF22B8B90, 0x00000000},	/* 173 */
  {0x10B1B2C0, 0xE2583780, 0x1DA7C880, 0x0D258B90, 0xF228C1C0, 0x00000000},	/* 174 */
  {0x10B5B580, 0xE2557560, 0x1DAA8AA0, 0x0D244F50, 0xF225FB40, 0x00000000},	/* 175 */
  {0x10B9BA40, 0xE252B6C0, 0x1DAD4940, 0x0D230DB0, 0xF2233820, 0x00000000},	/* 176 */
  {0x10BDC0E0, 0xE24FFB20, 0x1DB004E0, 0x0D21C6D0, 0xF2207840, 0x00000000},	/* 177 */
  {0x10C1C9C0, 0xE24D4300, 0x1DB2BD00, 0x0D207A80, 0xF21DBBC0, 0x00000000},	/* 178 */
  {0x10C5D4A0, 0xE24A8E00, 0x1DB57200, 0x0D1F28E0, 0xF21B0260, 0x00000000},	/* 179 */
  {0x10C9E1C0, 0xE247DC40, 0x1DB823C0, 0x0D1DD1F0, 0xF2184C60, 0x00000000},	/* 180 */
  {0x10CDF0E0, 0xE2452DC0, 0x1DBAD240, 0x0D1C7590, 0xF2159980, 0x00000000},	/* 181 */
  {0x10D20240, 0xE2428260, 0x1DBD7DA0, 0x0D1B13D0, 0xF212E9F0, 0x00000000},	/* 182 */
  {0x10D615C0, 0xE23FDA40, 0x1DC025C0, 0x0D19ACB0, 0xF2103D90, 0x00000000},	/* 183 */
  {0x10DA2B80, 0xE23D3560, 0x1DC2CAA0, 0x0D184010, 0xF20D9470, 0x00000000},	/* 184 */
  {0x10DE4380, 0xE23A93C0, 0x1DC56C40, 0x0D16CE00, 0xF20AEE80, 0x00000000},	/* 185 */
  {0x10E25DC0, 0xE237F540, 0x1DC80AC0, 0x0D155660, 0xF2084BD0, 0x00000000},	/* 186 */
  {0x10E67A40, 0xE23559E0, 0x1DCAA620, 0x0D13D960, 0xF205AC40, 0x00000000},	/* 187 */
  {0x10EA9940, 0xE232C180, 0x1DCD3E80, 0x0D1256F0, 0xF2030FC0, 0x00000000},	/* 188 */
  {0x10EEBA80, 0xE2302C60, 0x1DCFD3A0, 0x0D10CEF0, 0xF2007680, 0x00000000},	/* 189 */
  {0x10F2DE20, 0xE22D9A40, 0x1DD265C0, 0x0D0F4180, 0xF1FDE070, 0x00000000},	/* 190 */
  {0x10F70420, 0xE22B0B80, 0x1DD4F480, 0x0D0DAE70, 0xF1FB4D60, 0x00000000},	/* 191 */
  {0x10FB2CC0, 0xE2287F80, 0x1DD78080, 0x0D0C15E0, 0xF1F8BD70, 0x00000000},	/* 192 */
  {0x10FF57A0, 0xE225F6E0, 0x1DDA0920, 0x0D0A77C0, 0xF1F630B0, 0x00000000},	/* 193 */
  {0x11038520, 0xE2237120, 0x1DDC8EE0, 0x0D08D410, 0xF1F3A6F0, 0x00000000},	/* 194 */
  {0x1107B500, 0xE220EEA0, 0x1DDF1160, 0x0D072AB0, 0xF1F12050, 0x00000000},	/* 195 */
  {0x110BE780, 0xE21E6F00, 0x1DE19100, 0x0D057BC0, 0xF1EE9CB0, 0x00000000},	/* 196 */
  {0x11101CA0, 0xE21BF260, 0x1DE40DA0, 0x0D03C740, 0xF1EC1C20, 0x00000000},	/* 197 */
  {0x11145460, 0xE21978C0, 0x1DE68740, 0x0D020D10, 0xF1E99E90, 0x00000000},	/* 198 */
  {0x11188EC0, 0xE2170220, 0x1DE8FDE0, 0x0D004D40, 0xF1E72410, 0x00000000},	/* 199 */
  {0x111CCBA0, 0xE2148EC0, 0x1DEB7140, 0x0CFE87B0, 0xF1E4ACA0, 0x00000000},	/* 200 */
  {0x11210B80, 0xE2121E00, 0x1DEDE200, 0x0CFCBC90, 0xF1E23810, 0x00000000},	/* 201 */
  {0x11254DA0, 0xE20FB080, 0x1DF04F80, 0x0CFAEB90, 0xF1DFC6B0, 0x00000000},	/* 202 */
  {0x112992E0, 0xE20D45C0, 0x1DF2BA40, 0x0CF914F0, 0xF1DD5820, 0x00000000},	/* 203 */
  {0x112DDAE0, 0xE20ADE00, 0x1DF52200, 0x0CF738A0, 0xF1DAEC80, 0x00000000},	/* 204 */
  {0x113225A0, 0xE2087960, 0x1DF786A0, 0x0CF55680, 0xF1D883F0, 0x00000000},	/* 205 */
  {0x11367340, 0xE2061760, 0x1DF9E8A0, 0x0CF36EA0, 0xF1D61E30, 0x00000000},	/* 206 */
  {0x113AC3A0, 0xE203B880, 0x1DFC4780, 0x0CF180E0, 0xF1D3BB80, 0x00000000},	/* 207 */
  {0x113F16E0, 0xE2015C80, 0x1DFEA380, 0x0CEF8D60, 0xF1D15BA0, 0x00000000},	/* 208 */
  {0x11436D40, 0xE1FF0320, 0x1E00FCE0, 0x0CED9420, 0xF1CEFEA0, 0x00000000},	/* 209 */
  {0x1147C660, 0xE1FCACE0, 0x1E035320, 0x0CEB94E0, 0xF1CCA4B0, 0x00000000},	/* 210 */
  {0x114C22A0, 0xE1FA5980, 0x1E05A680, 0x0CE98FE0, 0xF1CA4D80, 0x00000000},	/* 211 */
  {0x115081E0, 0xE1F808C0, 0x1E07F740, 0x0CE78500, 0xF1C7F910, 0x00000000},	/* 212 */
  {0x1154E420, 0xE1F5BB00, 0x1E0A4500, 0x0CE57430, 0xF1C5A7A0, 0x00000000},	/* 213 */
  {0x11594980, 0xE1F37000, 0x1E0C9000, 0x0CE35D80, 0xF1C35900, 0x00000000},	/* 214 */
  {0x115DB1C0, 0xE1F12800, 0x1E0ED800, 0x0CE140D0, 0xF1C10D40, 0x00000000},	/* 215 */
  {0x11621D80, 0xE1EEE280, 0x1E111D80, 0x0CDF1E50, 0xF1BEC440, 0x00000000},	/* 216 */
  {0x11668C20, 0xE1ECA000, 0x1E136000, 0x0CDCF5B0, 0xF1BC7E20, 0x00000000},	/* 217 */
  {0x116AFE00, 0xE1EA6060, 0x1E159FA0, 0x0CDAC720, 0xF1BA3AD0, 0x00000000},	/* 218 */
  {0x116F7360, 0xE1E82320, 0x1E17DCE0, 0x0CD892A0, 0xF1B7FA20, 0x00000000},	/* 219 */
  {0x1173EBA0, 0xE1E5E900, 0x1E1A1700, 0x0CD65800, 0xF1B5BC50, 0x00000000},	/* 220 */
  {0x11786760, 0xE1E3B160, 0x1E1C4EA0, 0x0CD41770, 0xF1B38130, 0x00000000},	/* 221 */
  {0x117CE660, 0xE1E17CA0, 0x1E1E8360, 0x0CD1D0C0, 0xF1B148F0, 0x00000000},	/* 222 */
  {0x118168C0, 0xE1DF4AA0, 0x1E20B560, 0x0CCF83F0, 0xF1AF1360, 0x00000000},	/* 223 */
  {0x1185EE60, 0xE1DD1B40, 0x1E22E4C0, 0x0CCD3110, 0xF1ACE080, 0x00000000},	/* 224 */
  {0x118A7780, 0xE1DAEEA0, 0x1E251160, 0x0CCAD810, 0xF1AAB060, 0x00000000},	/* 225 */
  {0x118F0420, 0xE1D8C4A0, 0x1E273B60, 0x0CC87900, 0xF1A882F0, 0x00000000},	/* 226 */
  {0x11939420, 0xE1D69D60, 0x1E2962A0, 0x0CC613A0, 0xF1A65830, 0x00000000},	/* 227 */
  {0x119827C0, 0xE1D478A0, 0x1E2B8760, 0x0CC3A830, 0xF1A43010, 0x00000000},	/* 228 */
  {0x119CBEE0, 0xE1D256A0, 0x1E2DA960, 0x0CC13680, 0xF1A20AB0, 0x00000000},	/* 229 */
  {0x11A15960, 0xE1D03780, 0x1E2FC880, 0x0CBEBE80, 0xF19FE800, 0x00000000},	/* 230 */
  {0x11A5F7C0, 0xE1CE1AC0, 0x1E31E540, 0x0CBC4060, 0xF19DC7F0, 0x00000000},	/* 231 */
  {0x11AA99A0, 0xE1CC0080, 0x1E33FF80, 0x0CB9BBF0, 0xF19BAA60, 0x00000000},	/* 232 */
  {0x11AF3F40, 0xE1C9E900, 0x1E361700, 0x0CB73140, 0xF1998F80, 0x00000000},	/* 233 */
  {0x11B3E880, 0xE1C7D420, 0x1E382BE0, 0x0CB4A040, 0xF1977750, 0x00000000},	/* 234 */
  {0x11B89560, 0xE1C5C1E0, 0x1E3A3E20, 0x0CB208D0, 0xF19561B0, 0x00000000},	/* 235 */
  {0x11BD4660, 0xE1C3B200, 0x1E3C4E00, 0x0CAF6B30, 0xF1934EA0, 0x00000000},	/* 236 */
  {0x11C1FAC0, 0xE1C1A500, 0x1E3E5B00, 0x0CACC710, 0xF1913E30, 0x00000000},	/* 237 */
  {0x11C6B340, 0xE1BF9A20, 0x1E4065E0, 0x0CAA1CA0, 0xF18F3040, 0x00000000},	/* 238 */
  {0x11CB6F60, 0xE1BD9200, 0x1E426E00, 0x0CA76BD0, 0xF18D24D0, 0x00000000},	/* 239 */
  {0x11D02F80, 0xE1BB8C80, 0x1E447380, 0x0CA4B460, 0xF18B1C10, 0x00000000},	/* 240 */
  {0x11D4F3A0, 0xE1B98980, 0x1E467680, 0x0CA1F6A0, 0xF18915D0, 0x00000000},	/* 241 */
  {0x11D9BB80, 0xE1B78900, 0x1E487700, 0x0C9F3250, 0xF1871210, 0x00000000},	/* 242 */
  {0x11DE87A0, 0xE1B58AE0, 0x1E4A7520, 0x0C9C6790, 0xF18510D0, 0x00000000},	/* 243 */
  {0x11E357C0, 0xE1B38F60, 0x1E4C70A0, 0x0C999640, 0xF1831210, 0x00000000},	/* 244 */
  {0x11E82BC0, 0xE1B19640, 0x1E4E69C0, 0x0C96BE60, 0xF18115D0, 0x00000000},	/* 245 */
  {0x11ED0400, 0xE1AF9FA0, 0x1E506060, 0x0C93DFF0, 0xF17F1C10, 0x00000000},	/* 246 */
  {0x11F1E040, 0xE1ADAB80, 0x1E525480, 0x0C90FAF0, 0xF17D24C0, 0x00000000},	/* 247 */
  {0x11F6C0C0, 0xE1ABB9C0, 0x1E544640, 0x0C8E0F40, 0xF17B2FF0, 0x00000000},	/* 248 */
  {0x11FBA580, 0xE1A9CA80, 0x1E563580, 0x0C8B1CF0, 0xF1793D90, 0x00000000},	/* 249 */
  {0x12008E80, 0xE1A7DD80, 0x1E582280, 0x0C8823F0, 0xF1774D90, 0x00000000},	/* 250 */
  {0x12057BA0, 0xE1A5F300, 0x1E5A0D00, 0x0C852450, 0xF1756000, 0x00000000},	/* 251 */
  {0x120A6D40, 0xE1A40AE0, 0x1E5BF520, 0x0C821DF0, 0xF17374E0, 0x00000000},	/* 252 */
  {0x120F6320, 0xE1A22560, 0x1E5DDAA0, 0x0C7F10C0, 0xF1718C30, 0x00000000},	/* 253 */
  {0x12145D40, 0xE1A04200, 0x1E5FBE00, 0x0C7BFCE0, 0xF16FA5E0, 0x00000000},	/* 254 */
  {0x12195BE0, 0xE19E6140, 0x1E619EC0, 0x0C78E230, 0xF16DC200, 0x00000000},	/* 255 */
  {0x121E5F00, 0xE19C82A0, 0x1E637D60, 0x0C75C0A0, 0xF16BE070, 0x00000000},	/* 256 */
  {0, 0, 0, 0, 0, 0}
};

static const unsigned int eq_band3_data[][6] = {
  {0x0A8FA710, 0xF0DE1CC0, 0x0F21E340, 0x06E98708, 0xFE86D1E6, 0x00000000},	/* 0 */
  {0x0A98CEF0, 0xF0D49FD0, 0x0F2B6030, 0x06EB53F0, 0xFE7BDD2A, 0x00000000},	/* 1 */
  {0x0AA1FC80, 0xF0CB2420, 0x0F34DBE0, 0x06ED1998, 0xFE70E9E2, 0x00000000},	/* 2 */
  {0x0AAB3000, 0xF0C1A9A0, 0x0F3E5660, 0x06EED7F0, 0xFE65F80C, 0x00000000},	/* 3 */
  {0x0AB46950, 0xF0B83090, 0x0F47CF70, 0x06F08EE8, 0xFE5B07C8, 0x00000000},	/* 4 */
  {0x0ABDA890, 0xF0AEB8C0, 0x0F514740, 0x06F23E78, 0xFE501902, 0x00000000},	/* 5 */
  {0x0AC6EDA0, 0xF0A54260, 0x0F5ABDA0, 0x06F3E688, 0xFE452BDE, 0x00000000},	/* 6 */
  {0x0AD038B0, 0xF09BCD60, 0x0F6432A0, 0x06F58708, 0xFE3A4050, 0x00000000},	/* 7 */
  {0x0AD98990, 0xF09259D0, 0x0F6DA630, 0x06F71FE8, 0xFE2F567E, 0x00000000},	/* 8 */
  {0x0AE2E090, 0xF088E7B0, 0x0F771850, 0x06F8B138, 0xFE246E4E, 0x00000000},	/* 9 */
  {0x0AEC3D60, 0xF07F7720, 0x0F8088E0, 0x06FA3AC0, 0xFE1987EE, 0x00000000},	/* 10 */
  {0x0AF5A040, 0xF0760820, 0x0F89F7E0, 0x06FBBC80, 0xFE0EA350, 0x00000000},	/* 11 */
  {0x0AFF0920, 0xF06C9AC0, 0x0F936540, 0x06FD3668, 0xFE03C092, 0x00000000},	/* 12 */
  {0x0B0877F0, 0xF0632EF0, 0x0F9CD110, 0x06FEA868, 0xFDF8DFA8, 0x00000000},	/* 13 */
  {0x0B11ECF0, 0xF059C4C0, 0x0FA63B40, 0x07001270, 0xFDEE00A0, 0x00000000},	/* 14 */
  {0x0B1B6800, 0xF0505C50, 0x0FAFA3B0, 0x07017470, 0xFDE32390, 0x00000000},	/* 15 */
  {0x0B24E910, 0xF046F590, 0x0FB90A70, 0x0702CE68, 0xFDD8487C, 0x00000000},	/* 16 */
  {0x0B2E7050, 0xF03D9090, 0x0FC26F70, 0x07042040, 0xFDCD6F70, 0x00000000},	/* 17 */
  {0x0B37FDB0, 0xF0342D60, 0x0FCBD2A0, 0x070569E0, 0xFDC2986C, 0x00000000},	/* 18 */
  {0x0B419140, 0xF02ACBE0, 0x0FD53420, 0x0706AB40, 0xFDB7C378, 0x00000000},	/* 19 */
  {0x0B4B2B00, 0xF0216C50, 0x0FDE93B0, 0x0707E450, 0xFDACF0B0, 0x00000000},	/* 20 */
  {0x0B54CAF0, 0xF0180EA0, 0x0FE7F160, 0x070914F8, 0xFDA22020, 0x00000000},	/* 21 */
  {0x0B5E7120, 0xF00EB2E0, 0x0FF14D20, 0x070A3D30, 0xFD9751B8, 0x00000000},	/* 22 */
  {0x0B681D90, 0xF0055910, 0x0FFAA6F0, 0x070B5CE8, 0xFD8C8590, 0x00000000},	/* 23 */
  {0x0B71D030, 0xEFFC0140, 0x1003FEC0, 0x070C7410, 0xFD81BBB4, 0x00000000},	/* 24 */
  {0x0B7B8930, 0xEFF2AB60, 0x100D54A0, 0x070D82A0, 0xFD76F428, 0x00000000},	/* 25 */
  {0x0B854890, 0xEFE957A0, 0x1016A860, 0x070E8880, 0xFD6C2EF8, 0x00000000},	/* 26 */
  {0x0B8F0E40, 0xEFE005E0, 0x101FFA20, 0x070F85A0, 0xFD616C28, 0x00000000},	/* 27 */
  {0x0B98DA40, 0xEFD6B640, 0x102949C0, 0x071079E8, 0xFD56ABD0, 0x00000000},	/* 28 */
  {0x0BA2ACC0, 0xEFCD68C0, 0x10329740, 0x07116558, 0xFD4BEDEC, 0x00000000},	/* 29 */
  {0x0BAC8590, 0xEFC41D80, 0x103BE280, 0x071247E8, 0xFD413290, 0x00000000},	/* 30 */
  {0x0BB664F0, 0xEFBAD460, 0x10452BA0, 0x07132170, 0xFD3679B0, 0x00000000},	/* 31 */
  {0x0BC04AB0, 0xEFB18D80, 0x104E7280, 0x0713F1E8, 0xFD2BC370, 0x00000000},	/* 32 */
  {0x0BCA36F0, 0xEFA84900, 0x1057B700, 0x0714B940, 0xFD210FD0, 0x00000000},	/* 33 */
  {0x0BD429C0, 0xEF9F06A0, 0x1060F960, 0x07157770, 0xFD165ECC, 0x00000000},	/* 34 */
  {0x0BDE2310, 0xEF95C6A0, 0x106A3960, 0x07162C58, 0xFD0BB084, 0x00000000},	/* 35 */
  {0x0BE82310, 0xEF8C8900, 0x10737700, 0x0716D808, 0xFD0104E8, 0x00000000},	/* 36 */
  {0x0BF22990, 0xEF834DC0, 0x107CB240, 0x07177A50, 0xFCF65C14, 0x00000000},	/* 37 */
  {0x0BFC36C0, 0xEF7A1500, 0x1085EB00, 0x07181328, 0xFCEBB60C, 0x00000000},	/* 38 */
  {0x0C064A90, 0xEF70DEA0, 0x108F2160, 0x0718A280, 0xFCE112DC, 0x00000000},	/* 39 */
  {0x0C106510, 0xEF67AAC0, 0x10985540, 0x07192850, 0xFCD67288, 0x00000000},	/* 40 */
  {0x0C1A8670, 0xEF5E7940, 0x10A186C0, 0x0719A490, 0xFCCBD514, 0x00000000},	/* 41 */
  {0x0C24AE60, 0xEF554A80, 0x10AAB580, 0x071A1710, 0xFCC13A98, 0x00000000},	/* 42 */
  {0x0C2EDD10, 0xEF4C1E40, 0x10B3E1C0, 0x071A7FD0, 0xFCB6A314, 0x00000000},	/* 43 */
  {0x0C3912B0, 0xEF42F4A0, 0x10BD0B60, 0x071ADEC8, 0xFCAC0E84, 0x00000000},	/* 44 */
  {0x0C434F10, 0xEF39CDA0, 0x10C63260, 0x071B33F0, 0xFCA17D10, 0x00000000},	/* 45 */
  {0x0C4D9250, 0xEF30A940, 0x10CF56C0, 0x071B7F10, 0xFC96EEA8, 0x00000000},	/* 46 */
  {0x0C57DC70, 0xEF2787A0, 0x10D87860, 0x071BC040, 0xFC8C6358, 0x00000000},	/* 47 */
  {0x0C622D80, 0xEF1E68A0, 0x10E19760, 0x071BF760, 0xFC81DB28, 0x00000000},	/* 48 */
  {0x0C6C8590, 0xEF154C60, 0x10EAB3A0, 0x071C2450, 0xFC77562C, 0x00000000},	/* 49 */
  {0x0C76E480, 0xEF0C3300, 0x10F3CD00, 0x071C4718, 0xFC6CD460, 0x00000000},	/* 50 */
  {0x0C814A80, 0xEF031C60, 0x10FCE3A0, 0x071C5FA8, 0xFC6255DC, 0x00000000},	/* 51 */
  {0x0C8BB780, 0xEEFA08A0, 0x1105F760, 0x071C6DE0, 0xFC57DA98, 0x00000000},	/* 52 */
  {0x0C962BB0, 0xEEF0F7C0, 0x110F0840, 0x071C71B8, 0xFC4D62A0, 0x00000000},	/* 53 */
  {0x0CA0A6F0, 0xEEE7E9C0, 0x11181640, 0x071C6B10, 0xFC42EDFC, 0x00000000},	/* 54 */
  {0x0CAB2940, 0xEEDEDEA0, 0x11212160, 0x071C59F0, 0xFC387CC0, 0x00000000},	/* 55 */
  {0x0CB5B2D0, 0xEED5D680, 0x112A2980, 0x071C3E38, 0xFC2E0EEC, 0x00000000},	/* 56 */
  {0x0CC043A0, 0xEECCD140, 0x11332EC0, 0x071C17E0, 0xFC23A484, 0x00000000},	/* 57 */
  {0x0CCADBA0, 0xEEC3CF20, 0x113C30E0, 0x071BE6D8, 0xFC193D90, 0x00000000},	/* 58 */
  {0x0CD57AE0, 0xEEBAD000, 0x11453000, 0x071BAAF8, 0xFC0EDA24, 0x00000000},	/* 59 */
  {0x0CE02170, 0xEEB1D3E0, 0x114E2C20, 0x071B6440, 0xFC047A44, 0x00000000},	/* 60 */
  {0x0CEACF70, 0xEEA8DAE0, 0x11572520, 0x071B12B0, 0xFBFA1DE8, 0x00000000},	/* 61 */
  {0x0CF584B0, 0xEE9FE500, 0x11601B00, 0x071AB628, 0xFBEFC530, 0x00000000},	/* 62 */
  {0x0D004170, 0xEE96F240, 0x11690DC0, 0x071A4E80, 0xFBE57008, 0x00000000},	/* 63 */
  {0x0D0B0590, 0xEE8E02C0, 0x1171FD40, 0x0719DBD0, 0xFBDB1EA0, 0x00000000},	/* 64 */
  {0x0D15D140, 0xEE851660, 0x117AE9A0, 0x07195DF0, 0xFBD0D0D8, 0x00000000},	/* 65 */
  {0x0D20A460, 0xEE7C2D40, 0x1183D2C0, 0x0718D4D0, 0xFBC686D0, 0x00000000},	/* 66 */
  {0x0D2B7F10, 0xEE734760, 0x118CB8A0, 0x07184060, 0xFBBC4088, 0x00000000},	/* 67 */
  {0x0D366170, 0xEE6A64A0, 0x11959B60, 0x0717A090, 0xFBB1FE00, 0x00000000},	/* 68 */
  {0x0D414B60, 0xEE618560, 0x119E7AA0, 0x0716F548, 0xFBA7BF58, 0x00000000},	/* 69 */
  {0x0D4C3D00, 0xEE58A960, 0x11A756A0, 0x07163E88, 0xFB9D8470, 0x00000000},	/* 70 */
  {0x0D573660, 0xEE4FD0A0, 0x11B02F60, 0x07157C40, 0xFB934D70, 0x00000000},	/* 71 */
  {0x0D623760, 0xEE46FB60, 0x11B904A0, 0x0714AE40, 0xFB891A60, 0x00000000},	/* 72 */
  {0x0D6D4050, 0xEE3E2980, 0x11C1D680, 0x0713D490, 0xFB7EEB30, 0x00000000},	/* 73 */
  {0x0D7850E0, 0xEE355B20, 0x11CAA4E0, 0x0712EF10, 0xFB74C008, 0x00000000},	/* 74 */
  {0x0D836960, 0xEE2C9020, 0x11D36FE0, 0x0711FDC0, 0xFB6A98C8, 0x00000000},	/* 75 */
  {0x0D8E89D0, 0xEE23C8A0, 0x11DC3760, 0x07110090, 0xFB6075A0, 0x00000000},	/* 76 */
  {0x0D99B240, 0xEE1B04A0, 0x11E4FB60, 0x070FF758, 0xFB565670, 0x00000000},	/* 77 */
  {0x0DA4E2A0, 0xEE124420, 0x11EDBBE0, 0x070EE210, 0xFB4C3B60, 0x00000000},	/* 78 */
  {0x0DB01B00, 0xEE098740, 0x11F678C0, 0x070DC0A8, 0xFB422460, 0x00000000},	/* 79 */
  {0x0DBB5B70, 0xEE00CDE0, 0x11FF3220, 0x070C9310, 0xFB381180, 0x00000000},	/* 80 */
  {0x0DC6A3E0, 0xEDF81820, 0x1207E7E0, 0x070B5938, 0xFB2E02D0, 0x00000000},	/* 81 */
  {0x0DD1F4B0, 0xEDEF6600, 0x12109A00, 0x070A1320, 0xFB23F850, 0x00000000},	/* 82 */
  {0x0DDD4D80, 0xEDE6B780, 0x12194880, 0x0708C088, 0xFB19F200, 0x00000000},	/* 83 */
  {0x0DE8AE90, 0xEDDE0CC0, 0x1221F340, 0x07076178, 0xFB0FEFF0, 0x00000000},	/* 84 */
  {0x0DF417F0, 0xEDD565A0, 0x122A9A60, 0x0705F5E8, 0xFB05F220, 0x00000000},	/* 85 */
  {0x0DFF89B0, 0xEDCCC220, 0x12333DE0, 0x07047DC8, 0xFAFBF898, 0x00000000},	/* 86 */
  {0x0E0B03C0, 0xEDC42260, 0x123BDDA0, 0x0702F8E8, 0xFAF20360, 0x00000000},	/* 87 */
  {0x0E168620, 0xEDBB86A0, 0x12447960, 0x07016748, 0xFAE81290, 0x00000000},	/* 88 */
  {0x0E221110, 0xEDB2EE60, 0x124D11A0, 0x06FFC8E8, 0xFADE2608, 0x00000000},	/* 89 */
  {0x0E2DA480, 0xEDAA5A20, 0x1255A5E0, 0x06FE1D98, 0xFAD43DF0, 0x00000000},	/* 90 */
  {0x0E394070, 0xEDA1C980, 0x125E3680, 0x06FC6558, 0xFACA5A40, 0x00000000},	/* 91 */
  {0x0E44E4F0, 0xED993D00, 0x1266C300, 0x06FAA008, 0xFAC07B10, 0x00000000},	/* 92 */
  {0x0E509210, 0xED90B420, 0x126F4BE0, 0x06F8CDA0, 0xFAB6A048, 0x00000000},	/* 93 */
  {0x0E5C47F0, 0xED882F40, 0x1277D0C0, 0x06F6EE18, 0xFAACCA00, 0x00000000},	/* 94 */
  {0x0E680680, 0xED7FAE40, 0x128051C0, 0x06F50150, 0xFAA2F848, 0x00000000},	/* 95 */
  {0x0E73CDD0, 0xED773140, 0x1288CEC0, 0x06F30728, 0xFA992B08, 0x00000000},	/* 96 */
  {0x0E7F9DF0, 0xED6EB840, 0x129147C0, 0x06F0FFA8, 0xFA8F6268, 0x00000000},	/* 97 */
  {0x0E8B7700, 0xED664300, 0x1299BD00, 0x06EEEAB0, 0xFA859E58, 0x00000000},	/* 98 */
  {0x0E9758F0, 0xED5DD200, 0x12A22E00, 0x06ECC838, 0xFA7BDEF0, 0x00000000},	/* 99 */
  {0x0EA343C0, 0xED5564E0, 0x12AA9B20, 0x06EA9818, 0xFA722420, 0x00000000},	/* 100 */
  {0x0EAF37B0, 0xED4CFBE0, 0x12B30420, 0x06E85A50, 0xFA686E00, 0x00000000},	/* 101 */
  {0x0EBB34B0, 0xED4496E0, 0x12BB6920, 0x06E60EC0, 0xFA5EBC90, 0x00000000},	/* 102 */
  {0x0EC73AD0, 0xED3C35E0, 0x12C3CA20, 0x06E3B570, 0xFA550FC8, 0x00000000},	/* 103 */
  {0x0ED34A00, 0xED33D920, 0x12CC26E0, 0x06E14E38, 0xFA4B67D0, 0x00000000},	/* 104 */
  {0x0EDF6270, 0xED2B8060, 0x12D47FA0, 0x06DED8F0, 0xFA41C488, 0x00000000},	/* 105 */
  {0x0EEB8420, 0xED232BE0, 0x12DCD420, 0x06DC55C0, 0xFA382610, 0x00000000},	/* 106 */
  {0x0EF7AF50, 0xED1ADB60, 0x12E524A0, 0x06D9C460, 0xFA2E8C60, 0x00000000},	/* 107 */
  {0x0F03E3A0, 0xED128F40, 0x12ED70C0, 0x06D724D0, 0xFA24F780, 0x00000000},	/* 108 */
  {0x0F102170, 0xED0A4720, 0x12F5B8E0, 0x06D47700, 0xFA1B6788, 0x00000000},	/* 109 */
  {0x0F1C68E0, 0xED020340, 0x12FDFCC0, 0x06D1BAE0, 0xFA11DC50, 0x00000000},	/* 110 */
  {0x0F28B9B0, 0xECF9C3A0, 0x13063C60, 0x06CEF050, 0xFA085608, 0x00000000},	/* 111 */
  {0x0F351420, 0xECF18840, 0x130E77C0, 0x06CC1740, 0xF9FED4A8, 0x00000000},	/* 112 */
  {0x0F417830, 0xECE95120, 0x1316AEE0, 0x06C92FB0, 0xF9F55830, 0x00000000},	/* 113 */
  {0x0F4DE5F0, 0xECE11E60, 0x131EE1A0, 0x06C63960, 0xF9EBE0A8, 0x00000000},	/* 114 */
  {0x0F5A5D60, 0xECD8EFE0, 0x13271020, 0x06C33470, 0xF9E26E28, 0x00000000},	/* 115 */
  {0x0F66DEC0, 0xECD0C5A0, 0x132F3A60, 0x06C020B0, 0xF9D90090, 0x00000000},	/* 116 */
  {0x0F7369F0, 0xECC89FC0, 0x13376040, 0x06BCFE10, 0xF9CF97F8, 0x00000000},	/* 117 */
  {0x0F7FFF00, 0xECC07E40, 0x133F81C0, 0x06B9CC88, 0xF9C63478, 0x00000000},	/* 118 */
  {0x0F8C9E20, 0xECB86100, 0x13479F00, 0x06B68C00, 0xF9BCD5F0, 0x00000000},	/* 119 */
  {0x0F994730, 0xECB04840, 0x134FB7C0, 0x06B33C58, 0xF9B37C78, 0x00000000},	/* 120 */
  {0x0FA5FA60, 0xECA833E0, 0x1357CC20, 0x06AFDD88, 0xF9AA2828, 0x00000000},	/* 121 */
  {0x0FB2B7A0, 0xECA023E0, 0x135FDC20, 0x06AC6F78, 0xF9A0D8E0, 0x00000000},	/* 122 */
  {0x0FBF7F30, 0xEC981860, 0x1367E7A0, 0x06A8F210, 0xF9978EC0, 0x00000000},	/* 123 */
  {0x0FCC5110, 0xEC901140, 0x136FEEC0, 0x06A56550, 0xF98E49B8, 0x00000000},	/* 124 */
  {0x0FD92D10, 0xEC880EA0, 0x1377F160, 0x06A1C908, 0xF98509E0, 0x00000000},	/* 125 */
  {0x0FE61390, 0xEC801080, 0x137FEF80, 0x069E1D38, 0xF97BCF30, 0x00000000},	/* 126 */
  {0x0FF30480, 0xEC7816E0, 0x1387E920, 0x069A61C0, 0xF97299B0, 0x00000000},	/* 127 */
  {0x10000000, 0xEC7021C0, 0x138FDE40, 0x069696A0, 0xF9696960, 0x00000000},	/* 128 */
  {0x100D0600, 0xEC683120, 0x1397CEE0, 0x0692BBA8, 0xF9603E48, 0x00000000},	/* 129 */
  {0x101A16C0, 0xEC604500, 0x139FBB00, 0x068ED0E0, 0xF9571878, 0x00000000},	/* 130 */
  {0x10273200, 0xEC585D80, 0x13A7A280, 0x068AD618, 0xF94DF7E8, 0x00000000},	/* 131 */
  {0x10345800, 0xEC507A80, 0x13AF8580, 0x0686CB50, 0xF944DC98, 0x00000000},	/* 132 */
  {0x10418900, 0xEC489C00, 0x13B76400, 0x0682B070, 0xF93BC690, 0x00000000},	/* 133 */
  {0x104EC4E0, 0xEC40C240, 0x13BF3DC0, 0x067E8560, 0xF932B5D8, 0x00000000},	/* 134 */
  {0x105C0B80, 0xEC38ED20, 0x13C712E0, 0x067A4A08, 0xF929AA78, 0x00000000},	/* 135 */
  {0x10695D40, 0xEC311C80, 0x13CEE380, 0x0675FE50, 0xF920A458, 0x00000000},	/* 136 */
  {0x1076BA20, 0xEC295080, 0x13D6AF80, 0x0671A238, 0xF917A3A8, 0x00000000},	/* 137 */
  {0x10842220, 0xEC218940, 0x13DE76C0, 0x066D35A0, 0xF90EA850, 0x00000000},	/* 138 */
  {0x10919540, 0xEC19C6A0, 0x13E63960, 0x0668B870, 0xF905B250, 0x00000000},	/* 139 */
  {0x109F13C0, 0xEC1208C0, 0x13EDF740, 0x06642A90, 0xF8FCC1C0, 0x00000000},	/* 140 */
  {0x10AC9D80, 0xEC0A4F60, 0x13F5B0A0, 0x065F8C00, 0xF8F3D690, 0x00000000},	/* 141 */
  {0x10BA32A0, 0xEC029AC0, 0x13FD6540, 0x065ADC88, 0xF8EAF0D0, 0x00000000},	/* 142 */
  {0x10C7D360, 0xEBFAEAE0, 0x14051520, 0x06561C20, 0xF8E21078, 0x00000000},	/* 143 */
  {0x10D57FA0, 0xEBF33FC0, 0x140CC040, 0x06514AD0, 0xF8D935A0, 0x00000000},	/* 144 */
  {0x10E33760, 0xEBEB9940, 0x141466C0, 0x064C6860, 0xF8D06030, 0x00000000},	/* 145 */
  {0x10F0FB00, 0xEBE3F780, 0x141C0880, 0x064774C8, 0xF8C79038, 0x00000000},	/* 146 */
  {0x10FECA60, 0xEBDC5A80, 0x1423A580, 0x06426FF8, 0xF8BEC5C0, 0x00000000},	/* 147 */
  {0x110CA560, 0xEBD4C260, 0x142B3DA0, 0x063D59D0, 0xF8B600D8, 0x00000000},	/* 148 */
  {0x111A8C60, 0xEBCD2EE0, 0x1432D120, 0x06383240, 0xF8AD4158, 0x00000000},	/* 149 */
  {0x11287F60, 0xEBC5A060, 0x143A5FA0, 0x0632F938, 0xF8A48770, 0x00000000},	/* 150 */
  {0x11367E60, 0xEBBE1680, 0x1441E980, 0x062DAE98, 0xF89BD318, 0x00000000},	/* 151 */
  {0x11448980, 0xEBB69180, 0x14496E80, 0x06285248, 0xF8932448, 0x00000000},	/* 152 */
  {0x1152A0C0, 0xEBAF1160, 0x1450EEA0, 0x0622E438, 0xF88A7B00, 0x00000000},	/* 153 */
  {0x1160C460, 0xEBA795E0, 0x14586A20, 0x061D6458, 0xF881D748, 0x00000000},	/* 154 */
  {0x116EF440, 0xEBA01F60, 0x145FE0A0, 0x0617D280, 0xF8793928, 0x00000000},	/* 155 */
  {0x117D3080, 0xEB98ADC0, 0x14675240, 0x06122EC8, 0xF870A0A8, 0x00000000},	/* 156 */
  {0x118B7960, 0xEB9140E0, 0x146EBF20, 0x060C78D8, 0xF8680DB8, 0x00000000},	/* 157 */
  {0x1199CEC0, 0xEB89D8C0, 0x14762740, 0x0606B0D0, 0xF85F8068, 0x00000000},	/* 158 */
  {0x11A830C0, 0xEB8275A0, 0x147D8A60, 0x0600D680, 0xF856F8B8, 0x00000000},	/* 159 */
  {0x11B69F80, 0xEB7B1760, 0x1484E8A0, 0x05FAE9D8, 0xF84E76B0, 0x00000000},	/* 160 */
  {0x11C51B00, 0xEB73BE20, 0x148C41E0, 0x05F4EAB0, 0xF845FA50, 0x00000000},	/* 161 */
  {0x11D3A360, 0xEB6C69A0, 0x14939660, 0x05EED910, 0xF83D8388, 0x00000000},	/* 162 */
  {0x11E238C0, 0xEB651A00, 0x149AE600, 0x05E8B4D8, 0xF8351268, 0x00000000},	/* 163 */
  {0x11F0DB20, 0xEB5DCF60, 0x14A230A0, 0x05E27DF0, 0xF82CA708, 0x00000000},	/* 164 */
  {0x11FF8A80, 0xEB5689C0, 0x14A97640, 0x05DC3430, 0xF8244158, 0x00000000},	/* 165 */
  {0x120E4720, 0xEB4F48E0, 0x14B0B720, 0x05D5D798, 0xF81BE148, 0x00000000},	/* 166 */
  {0x121D1100, 0xEB480D00, 0x14B7F300, 0x05CF6800, 0xF81386F0, 0x00000000},	/* 167 */
  {0x122BE820, 0xEB40D640, 0x14BF29C0, 0x05C8E568, 0xF80B3258, 0x00000000},	/* 168 */
  {0x123ACCE0, 0xEB39A420, 0x14C65BE0, 0x05C24FA8, 0xF802E360, 0x00000000},	/* 169 */
  {0x1249BF20, 0xEB327720, 0x14CD88E0, 0x05BBA6A8, 0xF7FA9A30, 0x00000000},	/* 170 */
  {0x1258BF00, 0xEB2B4F20, 0x14D4B0E0, 0x05B4EA58, 0xF7F256C0, 0x00000000},	/* 171 */
  {0x1267CC80, 0xEB242C00, 0x14DBD400, 0x05AE1A98, 0xF7EA1900, 0x00000000},	/* 172 */
  {0x1276E7A0, 0xEB1D0E00, 0x14E2F200, 0x05A73750, 0xF7E1E110, 0x00000000},	/* 173 */
  {0x128610A0, 0xEB15F4E0, 0x14EA0B20, 0x05A04080, 0xF7D9AEE0, 0x00000000},	/* 174 */
  {0x129547C0, 0xEB0EE0A0, 0x14F11F60, 0x059935F8, 0xF7D18260, 0x00000000},	/* 175 */
  {0x12A48CC0, 0xEB07D1A0, 0x14F82E60, 0x059217A0, 0xF7C95BA0, 0x00000000},	/* 176 */
  {0x12B3DFC0, 0xEB00C780, 0x14FF3880, 0x058AE570, 0xF7C13AC0, 0x00000000},	/* 177 */
  {0x12C34120, 0xEAF9C240, 0x15063DC0, 0x05839F48, 0xF7B91F90, 0x00000000},	/* 178 */
  {0x12D2B0C0, 0xEAF2C220, 0x150D3DE0, 0x057C4510, 0xF7B10A30, 0x00000000},	/* 179 */
  {0x12E22EC0, 0xEAEBC700, 0x15143900, 0x0574D6B0, 0xF7A8FAA0, 0x00000000},	/* 180 */
  {0x12F1BB20, 0xEAE4D100, 0x151B2F00, 0x056D5410, 0xF7A0F0E0, 0x00000000},	/* 181 */
  {0x13015600, 0xEADDDFE0, 0x15222020, 0x0565BD20, 0xF798ECE0, 0x00000000},	/* 182 */
  {0x1310FF80, 0xEAD6F400, 0x15290C00, 0x055E11B8, 0xF790EEC0, 0x00000000},	/* 183 */
  {0x1320B7E0, 0xEAD00CE0, 0x152FF320, 0x055651C0, 0xF788F660, 0x00000000},	/* 184 */
  {0x13307F00, 0xEAC92B00, 0x1536D500, 0x054E7D30, 0xF78103E0, 0x00000000},	/* 185 */
  {0x13405500, 0xEAC24E00, 0x153DB200, 0x054693E8, 0xF7791720, 0x00000000},	/* 186 */
  {0x13503A00, 0xEABB7620, 0x154489E0, 0x053E95D0, 0xF7713040, 0x00000000},	/* 187 */
  {0x13602E00, 0xEAB4A360, 0x154B5CA0, 0x053682C8, 0xF7694F30, 0x00000000},	/* 188 */
  {0x13703160, 0xEAADD580, 0x15522A80, 0x052E5AC0, 0xF76173F0, 0x00000000},	/* 189 */
  {0x138043C0, 0xEAA70CE0, 0x1558F320, 0x05261DA0, 0xF7599E90, 0x00000000},	/* 190 */
  {0x139065C0, 0xEAA04940, 0x155FB6C0, 0x051DCB48, 0xF751CF10, 0x00000000},	/* 191 */
  {0x13A09700, 0xEA998AA0, 0x15667560, 0x05156390, 0xF74A0550, 0x00000000},	/* 192 */
  {0x13B0D800, 0xEA92D120, 0x156D2EE0, 0x050CE680, 0xF7424180, 0x00000000},	/* 193 */
  {0x13C12880, 0xEA8C1CA0, 0x1573E360, 0x050453F0, 0xF73A8390, 0x00000000},	/* 194 */
  {0x13D188E0, 0xEA856D40, 0x157A92C0, 0x04FBABB8, 0xF732CB60, 0x00000000},	/* 195 */
  {0x13E1F920, 0xEA7EC300, 0x15813D00, 0x04F2EDD8, 0xF72B1920, 0x00000000},	/* 196 */
  {0x13F27940, 0xEA781DA0, 0x1587E260, 0x04EA1A30, 0xF7236CA0, 0x00000000},	/* 197 */
  {0x14030960, 0xEA717D80, 0x158E8280, 0x04E13098, 0xF71BC610, 0x00000000},	/* 198 */
  {0x1413A9A0, 0xEA6AE280, 0x15951D80, 0x04D830F8, 0xF7142570, 0x00000000},	/* 199 */
  {0x14245A40, 0xEA644C60, 0x159BB3A0, 0x04CF1B48, 0xF70C8A90, 0x00000000},	/* 200 */
  {0x14351B20, 0xEA5DBB80, 0x15A24480, 0x04C5EF58, 0xF704F5A0, 0x00000000},	/* 201 */
  {0x1445EC60, 0xEA572FC0, 0x15A8D040, 0x04BCAD18, 0xF6FD6690, 0x00000000},	/* 202 */
  {0x1456CE40, 0xEA50A900, 0x15AF5700, 0x04B35470, 0xF6F5DD60, 0x00000000},	/* 203 */
  {0x1467C0C0, 0xEA4A2740, 0x15B5D8C0, 0x04A9E548, 0xF6EE5A00, 0x00000000},	/* 204 */
  {0x1478C400, 0xEA43AAC0, 0x15BC5540, 0x04A05F78, 0xF6E6DC90, 0x00000000},	/* 205 */
  {0x1489D820, 0xEA3D3340, 0x15C2CCC0, 0x0496C2F0, 0xF6DF64E0, 0x00000000},	/* 206 */
  {0x149AFD20, 0xEA36C0E0, 0x15C93F20, 0x048D0F98, 0xF6D7F340, 0x00000000},	/* 207 */
  {0x14AC3360, 0xEA305380, 0x15CFAC80, 0x04834550, 0xF6D08760, 0x00000000},	/* 208 */
  {0x14BD7AA0, 0xEA29EB40, 0x15D614C0, 0x047963F0, 0xF6C92160, 0x00000000},	/* 209 */
  {0x14CED320, 0xEA238840, 0x15DC77C0, 0x046F6B78, 0xF6C1C150, 0x00000000},	/* 210 */
  {0x14E03D20, 0xEA1D2A20, 0x15E2D5E0, 0x04655BB8, 0xF6BA6720, 0x00000000},	/* 211 */
  {0x14F1B8A0, 0xEA16D140, 0x15E92EC0, 0x045B3498, 0xF6B312D0, 0x00000000},	/* 212 */
  {0x150345C0, 0xEA107D40, 0x15EF82C0, 0x0450F610, 0xF6ABC450, 0x00000000},	/* 213 */
  {0x1514E460, 0xEA0A2E80, 0x15F5D180, 0x04469FE0, 0xF6A47BC0, 0x00000000},	/* 214 */
  {0x152694E0, 0xEA03E4E0, 0x15FC1B20, 0x043C3208, 0xF69D3910, 0x00000000},	/* 215 */
  {0x15385780, 0xE9FDA040, 0x16025FC0, 0x0431AC68, 0xF695FC40, 0x00000000},	/* 216 */
  {0x154A2BE0, 0xE9F760C0, 0x16089F40, 0x04270ED8, 0xF68EC540, 0x00000000},	/* 217 */
  {0x155C12A0, 0xE9F12640, 0x160ED9C0, 0x041C5948, 0xF6879430, 0x00000000},	/* 218 */
  {0x156E0B80, 0xE9EAF100, 0x16150F00, 0x04118B90, 0xF6806900, 0x00000000},	/* 219 */
  {0x158016C0, 0xE9E4C0C0, 0x161B3F40, 0x0406A5A8, 0xF67943B0, 0x00000000},	/* 220 */
  {0x15923460, 0xE9DE95A0, 0x16216A60, 0x03FBA760, 0xF6722430, 0x00000000},	/* 221 */
  {0x15A464E0, 0xE9D86F80, 0x16279080, 0x03F090A8, 0xF66B0A90, 0x00000000},	/* 222 */
  {0x15B6A7E0, 0xE9D24E80, 0x162DB180, 0x03E56150, 0xF663F6D0, 0x00000000},	/* 223 */
  {0x15C8FDC0, 0xE9CC3280, 0x1633CD80, 0x03DA194C, 0xF65CE8F0, 0x00000000},	/* 224 */
  {0x15DB66A0, 0xE9C61BA0, 0x1639E460, 0x03CEB880, 0xF655E0F0, 0x00000000},	/* 225 */
  {0x15EDE280, 0xE9C009E0, 0x163FF620, 0x03C33ED0, 0xF64EDEC0, 0x00000000},	/* 226 */
  {0x16007180, 0xE9B9FD40, 0x164602C0, 0x03B7AC08, 0xF647E280, 0x00000000},	/* 227 */
  {0x161313E0, 0xE9B3F580, 0x164C0A80, 0x03AC0028, 0xF640EC10, 0x00000000},	/* 228 */
  {0x1625C980, 0xE9ADF300, 0x16520D00, 0x03A03AFC, 0xF639FB70, 0x00000000},	/* 229 */
  {0x163892C0, 0xE9A7F580, 0x16580A80, 0x03945C74, 0xF63310C0, 0x00000000},	/* 230 */
  {0x164B6FE0, 0xE9A1FD00, 0x165E0300, 0x03886470, 0xF62C2BC0, 0x00000000},	/* 231 */
  {0x165E6080, 0xE99C09A0, 0x1663F660, 0x037C52CC, 0xF6254CC0, 0x00000000},	/* 232 */
  {0x16716520, 0xE9961B40, 0x1669E4C0, 0x03702770, 0xF61E7380, 0x00000000},	/* 233 */
  {0x16847DA0, 0xE9903200, 0x166FCE00, 0x0363E230, 0xF617A020, 0x00000000},	/* 234 */
  {0x1697AA60, 0xE98A4DC0, 0x1675B240, 0x03578300, 0xF610D280, 0x00000000},	/* 235 */
  {0x16AAEB80, 0xE9846E80, 0x167B9180, 0x034B09B4, 0xF60A0AD0, 0x00000000},	/* 236 */
  {0x16BE40E0, 0xE97E9460, 0x16816BA0, 0x033E7640, 0xF60348E0, 0x00000000},	/* 237 */
  {0x16D1AAC0, 0xE978BF40, 0x168740C0, 0x0331C874, 0xF5FC8CD0, 0x00000000},	/* 238 */
  {0x16E52940, 0xE972EF40, 0x168D10C0, 0x03250030, 0xF5F5D680, 0x00000000},	/* 239 */
  {0x16F8BCC0, 0xE96D2420, 0x1692DBE0, 0x03181D5C, 0xF5EF2600, 0x00000000},	/* 240 */
  {0x170C64E0, 0xE9675E20, 0x1698A1E0, 0x030B1FD8, 0xF5E87B60, 0x00000000},	/* 241 */
  {0x17202220, 0xE9619D00, 0x169E6300, 0x02FE0784, 0xF5E1D670, 0x00000000},	/* 242 */
  {0x1733F480, 0xE95BE120, 0x16A41EE0, 0x02F0D434, 0xF5DB3750, 0x00000000},	/* 243 */
  {0x1747DC00, 0xE9562A40, 0x16A9D5C0, 0x02E385DC, 0xF5D49E10, 0x00000000},	/* 244 */
  {0x175BD920, 0xE9507840, 0x16AF87C0, 0x02D61C4C, 0xF5CE0A90, 0x00000000},	/* 245 */
  {0x176FEBC0, 0xE94ACB40, 0x16B534C0, 0x02C89770, 0xF5C77CE0, 0x00000000},	/* 246 */
  {0x17841400, 0xE9452340, 0x16BADCC0, 0x02BAF72C, 0xF5C0F4E0, 0x00000000},	/* 247 */
  {0x17985200, 0xE93F8060, 0x16C07FA0, 0x02AD3B4C, 0xF5BA72B0, 0x00000000},	/* 248 */
  {0x17ACA600, 0xE939E260, 0x16C61DA0, 0x029F63BC, 0xF5B3F650, 0x00000000},	/* 249 */
  {0x17C11020, 0xE9344960, 0x16CBB6A0, 0x02917050, 0xF5AD7FA0, 0x00000000},	/* 250 */
  {0x17D59040, 0xE92EB560, 0x16D14AA0, 0x028360F8, 0xF5A70EB0, 0x00000000},	/* 251 */
  {0x17EA2720, 0xE9292640, 0x16D6D9C0, 0x0275358C, 0xF5A0A380, 0x00000000},	/* 252 */
  {0x17FED420, 0xE9239C40, 0x16DC63C0, 0x0266EDE4, 0xF59A3E10, 0x00000000},	/* 253 */
  {0x181397C0, 0xE91E1720, 0x16E1E8E0, 0x025889EC, 0xF593DE60, 0x00000000},	/* 254 */
  {0x18287220, 0xE9189720, 0x16E768E0, 0x024A096C, 0xF58D8470, 0x00000000},	/* 255 */
  {0x183D6380, 0xE9131BE0, 0x16ECE420, 0x023B6C64, 0xF5873030, 0x00000000},	/* 256 */
  {0, 0, 0, 0, 0, 0}
};

static const unsigned int eq_band4_data[][6] = {
  {0x08EDE970, 0x068EB7E8, 0xF9714818, 0x042F8650, 0x02E2902C, 0x00000000},	/* 0 */
  {0x08F87E00, 0x06941150, 0xF96BEEB0, 0x042FA4A0, 0x02D7DD6C, 0x00000000},	/* 1 */
  {0x09031E40, 0x06996C00, 0xF9669400, 0x042FB9C0, 0x02CD280C, 0x00000000},	/* 2 */
  {0x090DCA40, 0x069EC7F8, 0xF9613808, 0x042FC5B0, 0x02C2700C, 0x00000000},	/* 3 */
  {0x09188210, 0x06A42538, 0xF95BDAC8, 0x042FC860, 0x02B7B590, 0x00000000},	/* 4 */
  {0x092345D0, 0x06A983C0, 0xF9567C40, 0x042FC1B0, 0x02ACF880, 0x00000000},	/* 5 */
  {0x092E1590, 0x06AEE388, 0xF9511C78, 0x042FB180, 0x02A23900, 0x00000000},	/* 6 */
  {0x0938F130, 0x06B44480, 0xF94BBB80, 0x042F97C8, 0x029776F4, 0x00000000},	/* 7 */
  {0x0943D8F0, 0x06B9A6B0, 0xF9465950, 0x042F7468, 0x028CB2A0, 0x00000000},	/* 8 */
  {0x094ECCD0, 0x06BF0A18, 0xF940F5E8, 0x042F4758, 0x0281EBD4, 0x00000000},	/* 9 */
  {0x0959CCD0, 0x06C46EA0, 0xF93B9160, 0x042F1070, 0x027722C4, 0x00000000},	/* 10 */
  {0x0964D900, 0x06C9D448, 0xF9362BB8, 0x042ECFA0, 0x026C5760, 0x00000000},	/* 11 */
  {0x096FF170, 0x06CF3B18, 0xF930C4E8, 0x042E84C8, 0x026189C4, 0x00000000},	/* 12 */
  {0x097B1630, 0x06D4A308, 0xF92B5CF8, 0x042E2FE0, 0x0256B9E8, 0x00000000},	/* 13 */
  {0x09864760, 0x06DA0C10, 0xF925F3F0, 0x042DD0C8, 0x024BE7D8, 0x00000000},	/* 14 */
  {0x099184F0, 0x06DF7630, 0xF92089D0, 0x042D6768, 0x024113A4, 0x00000000},	/* 15 */
  {0x099CCF00, 0x06E4E150, 0xF91B1EB0, 0x042CF3A8, 0x02363D5C, 0x00000000},	/* 16 */
  {0x09A82590, 0x06EA4D80, 0xF915B280, 0x042C7568, 0x022B64FC, 0x00000000},	/* 17 */
  {0x09B388D0, 0x06EFBAB8, 0xF9104548, 0x042BECA0, 0x02208A94, 0x00000000},	/* 18 */
  {0x09BEF8B0, 0x06F528E8, 0xF90AD718, 0x042B5930, 0x0215AE28, 0x00000000},	/* 19 */
  {0x09CA7530, 0x06FA9818, 0xF90567E8, 0x042ABB00, 0x020ACFCC, 0x00000000},	/* 20 */
  {0x09D5FE80, 0x07000838, 0xF8FFF7C8, 0x042A11F0, 0x01FFEF90, 0x00000000},	/* 21 */
  {0x09E194A0, 0x07057948, 0xF8FA86B8, 0x04295DF0, 0x01F50D6A, 0x00000000},	/* 22 */
  {0x09ED37A0, 0x070AEB50, 0xF8F514B0, 0x04289EF0, 0x01EA296A, 0x00000000},	/* 23 */
  {0x09F8E790, 0x07105E30, 0xF8EFA1D0, 0x0427D4C0, 0x01DF439E, 0x00000000},	/* 24 */
  {0x0A04A490, 0x0715D200, 0xF8EA2E00, 0x0426FF68, 0x01D45C10, 0x00000000},	/* 25 */
  {0x0A106E90, 0x071B46A0, 0xF8E4B960, 0x04261EA8, 0x01C972C6, 0x00000000},	/* 26 */
  {0x0A1C45B0, 0x0720BC20, 0xF8DF43E0, 0x04253280, 0x01BE87D0, 0x00000000},	/* 27 */
  {0x0A2829F0, 0x07263260, 0xF8D9CDA0, 0x04243AD0, 0x01B39B34, 0x00000000},	/* 28 */
  {0x0A341B70, 0x072BA978, 0xF8D45688, 0x04233780, 0x01A8ACFE, 0x00000000},	/* 29 */
  {0x0A401A50, 0x07312160, 0xF8CEDEA0, 0x04222878, 0x019DBD3C, 0x00000000},	/* 30 */
  {0x0A4C2680, 0x07369A10, 0xF8C965F0, 0x04210DA0, 0x0192CBE6, 0x00000000},	/* 31 */
  {0x0A584000, 0x073C1370, 0xF8C3EC90, 0x041FE6D0, 0x0187D924, 0x00000000},	/* 32 */
  {0x0A646710, 0x07418D88, 0xF8BE7278, 0x041EB400, 0x017CE4E4, 0x00000000},	/* 33 */
  {0x0A709BB0, 0x07470868, 0xF8B8F798, 0x041D7510, 0x0171EF3A, 0x00000000},	/* 34 */
  {0x0A7CDDE0, 0x074C83D8, 0xF8B37C28, 0x041C29E0, 0x0166F83C, 0x00000000},	/* 35 */
  {0x0A892DC0, 0x07520010, 0xF8ADFFF0, 0x041AD260, 0x015BFFE2, 0x00000000},	/* 36 */
  {0x0A958B50, 0x07577CD8, 0xF8A88328, 0x04196E68, 0x0151063C, 0x00000000},	/* 37 */
  {0x0AA1F6C0, 0x075CFA58, 0xF8A305A8, 0x0417FDF0, 0x01460B5C, 0x00000000},	/* 38 */
  {0x0AAE6FF0, 0x07627860, 0xF89D87A0, 0x041680D8, 0x013B0F4C, 0x00000000},	/* 39 */
  {0x0ABAF700, 0x0767F6F8, 0xF8980908, 0x0414F6F0, 0x01301208, 0x00000000},	/* 40 */
  {0x0AC78C20, 0x076D7630, 0xF89289D0, 0x04136038, 0x012513A2, 0x00000000},	/* 41 */
  {0x0AD42F40, 0x0772F5E8, 0xF88D0A18, 0x0411BC90, 0x011A142E, 0x00000000},	/* 42 */
  {0x0AE0E080, 0x07787628, 0xF88789D8, 0x04100BD0, 0x010F13B0, 0x00000000},	/* 43 */
  {0x0AEDA000, 0x077DF6F0, 0xF8820910, 0x040E4DE8, 0x01041222, 0x00000000},	/* 44 */
  {0x0AFA6DA0, 0x07837830, 0xF87C87D0, 0x040C82C0, 0x00F90FB1, 0x00000000},	/* 45 */
  {0x0B074990, 0x0788F9D8, 0xF8770628, 0x040AAA30, 0x00EE0C46, 0x00000000},	/* 46 */
  {0x0B1433E0, 0x078E7C00, 0xF8718400, 0x0408C420, 0x00E307F9, 0x00000000},	/* 47 */
  {0x0B212CA0, 0x0793FE98, 0xF86C0168, 0x0406D080, 0x00D802D0, 0x00000000},	/* 48 */
  {0x0B2E33F0, 0x07998190, 0xF8667E70, 0x0404CF28, 0x00CCFCDD, 0x00000000},	/* 49 */
  {0x0B3B49D0, 0x079F04E8, 0xF860FB18, 0x0402C008, 0x00C1F627, 0x00000000},	/* 50 */
  {0x0B486E50, 0x07A488A8, 0xF85B7758, 0x0400A2F8, 0x00B6EEC1, 0x00000000},	/* 51 */
  {0x0B55A180, 0x07AA0CB0, 0xF855F350, 0x03FE77E4, 0x00ABE6A7, 0x00000000},	/* 52 */
  {0x0B62E380, 0x07AF9110, 0xF8506EF0, 0x03FC3EAC, 0x00A0DDEB, 0x00000000},	/* 53 */
  {0x0B703440, 0x07B515B8, 0xF84AEA48, 0x03F9F730, 0x0095D48A, 0x00000000},	/* 54 */
  {0x0B7D9410, 0x07BA9AB8, 0xF8456548, 0x03F7A160, 0x008ACAA3, 0x00000000},	/* 55 */
  {0x0B8B02B0, 0x07C01FE0, 0xF83FE020, 0x03F53D08, 0x007FC03D, 0x00000000},	/* 56 */
  {0x0B988080, 0x07C5A550, 0xF83A5AB0, 0x03F2CA28, 0x0074B556, 0x00000000},	/* 57 */
  {0x0BA60D70, 0x07CB2B08, 0xF834D4F8, 0x03F04894, 0x0069AA02, 0x00000000},	/* 58 */
  {0x0BB3A9A0, 0x07D0B0E0, 0xF82F4F20, 0x03EDB830, 0x005E9E47, 0x00000000},	/* 59 */
  {0x0BC154E0, 0x07D636E0, 0xF829C920, 0x03EB18DC, 0x00539239, 0x00000000},	/* 60 */
  {0x0BCF0FA0, 0x07DBBD10, 0xF82442F0, 0x03E86A84, 0x004885CB, 0x00000000},	/* 61 */
  {0x0BDCD9C0, 0x07E14368, 0xF81EBC98, 0x03E5AD08, 0x003D7927, 0x00000000},	/* 62 */
  {0x0BEAB380, 0x07E6C9E0, 0xF8193620, 0x03E2E048, 0x00326C41, 0x00000000},	/* 63 */
  {0x0BF89CB0, 0x07EC5068, 0xF813AF98, 0x03E00430, 0x00275F36, 0x00000000},	/* 64 */
  {0x0C069570, 0x07F1D700, 0xF80E2900, 0x03DD188C, 0x001C51F8, 0x00000000},	/* 65 */
  {0x0C149E00, 0x07F75DA8, 0xF808A258, 0x03DA1D58, 0x001144A9, 0x00000000},	/* 66 */
  {0x0C22B650, 0x07FCE458, 0xF8031BA8, 0x03D71260, 0x00063746, 0x00000000},	/* 67 */
  {0x0C30DE80, 0x08026B10, 0xF7FD94F0, 0x03D3F798, 0xFFFB29D9, 0x00000000},	/* 68 */
  {0x0C3F16B0, 0x0807F1C0, 0xF7F80E40, 0x03D0CCDC, 0xFFF01C75, 0x00000000},	/* 69 */
  {0x0C4D5EE0, 0x080D7870, 0xF7F28790, 0x03CD9208, 0xFFE50F19, 0x00000000},	/* 70 */
  {0x0C5BB710, 0x0812FF10, 0xF7ED00F0, 0x03CA4704, 0xFFDA01DA, 0x00000000},	/* 71 */
  {0x0C6A1F80, 0x081885A0, 0xF7E77A60, 0x03C6EBB4, 0xFFCEF4C2, 0x00000000},	/* 72 */
  {0x0C789820, 0x081E0C10, 0xF7E1F3F0, 0x03C37FF0, 0xFFC3E7DB, 0x00000000},	/* 73 */
  {0x0C872130, 0x08239270, 0xF7DC6D90, 0x03C003A8, 0xFFB8DB2E, 0x00000000},	/* 74 */
  {0x0C95BAA0, 0x082918A0, 0xF7D6E760, 0x03BC76B0, 0xFFADCEBC, 0x00000000},	/* 75 */
  {0x0CA46470, 0x082E9EB0, 0xF7D16150, 0x03B8D8F0, 0xFFA2C2A3, 0x00000000},	/* 76 */
  {0x0CB31EF0, 0x08342490, 0xF7CBDB70, 0x03B52A40, 0xFF97B6DA, 0x00000000},	/* 77 */
  {0x0CC1E9F0, 0x0839AA40, 0xF7C655C0, 0x03B16A88, 0xFF8CAB80, 0x00000000},	/* 78 */
  {0x0CD0C5C0, 0x083F2FC0, 0xF7C0D040, 0x03AD99AC, 0xFF81A089, 0x00000000},	/* 79 */
  {0x0CDFB270, 0x0844B500, 0xF7BB4B00, 0x03A9B78C, 0xFF76960B, 0x00000000},	/* 80 */
  {0x0CEEAFF0, 0x084A39F0, 0xF7B5C610, 0x03A5C404, 0xFF6B8C13, 0x00000000},	/* 81 */
  {0x0CFDBE60, 0x084FBEB0, 0xF7B04150, 0x03A1BEF4, 0xFF6082A8, 0x00000000},	/* 82 */
  {0x0D0CDDE0, 0x08554310, 0xF7AABCF0, 0x039DA844, 0xFF5579D9, 0x00000000},	/* 83 */
  {0x0D1C0E90, 0x085AC730, 0xF7A538D0, 0x03997FC8, 0xFF4A71A4, 0x00000000},	/* 84 */
  {0x0D2B5070, 0x08604AF0, 0xF79FB510, 0x03954568, 0xFF3F6A21, 0x00000000},	/* 85 */
  {0x0D3AA3A0, 0x0865CE50, 0xF79A31B0, 0x0390F908, 0xFF346358, 0x00000000},	/* 86 */
  {0x0D4A0830, 0x086B5160, 0xF794AEA0, 0x038C9A80, 0xFF295D4C, 0x00000000},	/* 87 */
  {0x0D597E30, 0x0870D3F0, 0xF78F2C10, 0x038829B4, 0xFF1E5814, 0x00000000},	/* 88 */
  {0x0D6905D0, 0x08765630, 0xF789A9D0, 0x0383A67C, 0xFF1353A5, 0x00000000},	/* 89 */
  {0x0D789F10, 0x087BD7F0, 0xF7842810, 0x037F10C4, 0xFF085021, 0x00000000},	/* 90 */
  {0x0D884A20, 0x08815940, 0xF77EA6C0, 0x037A6864, 0xFEFD4D88, 0x00000000},	/* 91 */
  {0x0D9806E0, 0x0886DA10, 0xF77925F0, 0x0375AD3C, 0xFEF24BE8, 0x00000000},	/* 92 */
  {0x0DA7D5A0, 0x088C5A60, 0xF773A5A0, 0x0370DF28, 0xFEE74B3E, 0x00000000},	/* 93 */
  {0x0DB7B650, 0x0891DA30, 0xF76E25D0, 0x036BFE08, 0xFEDC4BA8, 0x00000000},	/* 94 */
  {0x0DC7A920, 0x08975970, 0xF768A690, 0x036709C8, 0xFED14D20, 0x00000000},	/* 95 */
  {0x0DD7AE10, 0x089CD820, 0xF76327E0, 0x03620234, 0xFEC64FBA, 0x00000000},	/* 96 */
  {0x0DE7C550, 0x08A25640, 0xF75DA9C0, 0x035CE730, 0xFEBB537E, 0x00000000},	/* 97 */
  {0x0DF7EEF0, 0x08A7D3C0, 0xF7582C40, 0x0357B8A4, 0xFEB05878, 0x00000000},	/* 98 */
  {0x0E082AF0, 0x08AD50A0, 0xF752AF60, 0x03527660, 0xFEA55EAE, 0x00000000},	/* 99 */
  {0x0E187990, 0x08B2CCF0, 0xF74D3310, 0x034D2050, 0xFE9A662A, 0x00000000},	/* 100 */
  {0x0E28DAC0, 0x08B84880, 0xF747B780, 0x0347B648, 0xFE8F6EFC, 0x00000000},	/* 101 */
  {0x0E394EA0, 0x08BDC360, 0xF7423CA0, 0x03423824, 0xFE84792C, 0x00000000},	/* 102 */
  {0x0E49D570, 0x08C33DA0, 0xF73CC260, 0x033CA5D4, 0xFE7984C0, 0x00000000},	/* 103 */
  {0x0E5A6F20, 0x08C8B720, 0xF73748E0, 0x0336FF20, 0xFE6E91C4, 0x00000000},	/* 104 */
  {0x0E6B1BC0, 0x08CE2FE0, 0xF731D020, 0x033143F4, 0xFE63A046, 0x00000000},	/* 105 */
  {0x0E7BDB90, 0x08D3A7D0, 0xF72C5830, 0x032B7428, 0xFE58B054, 0x00000000},	/* 106 */
  {0x0E8CAE90, 0x08D91F10, 0xF726E0F0, 0x03258F94, 0xFE4DC1E8, 0x00000000},	/* 107 */
  {0x0E9D94D0, 0x08DE9570, 0xF7216A90, 0x031F9620, 0xFE42D51A, 0x00000000},	/* 108 */
  {0x0EAE8E70, 0x08E40B10, 0xF71BF4F0, 0x031987A4, 0xFE37E9F2, 0x00000000},	/* 109 */
  {0x0EBF9B90, 0x08E97FD0, 0xF7168030, 0x031363F8, 0xFE2D0070, 0x00000000},	/* 110 */
  {0x0ED0BC50, 0x08EEF3B0, 0xF7110C50, 0x030D2B00, 0xFE2218AA, 0x00000000},	/* 111 */
  {0x0EE1F0C0, 0x08F466B0, 0xF70B9950, 0x0306DC9C, 0xFE1732AA, 0x00000000},	/* 112 */
  {0x0EF33900, 0x08F9D8D0, 0xF7062730, 0x0300789C, 0xFE0C4E74, 0x00000000},	/* 113 */
  {0x0F049510, 0x08FF49F0, 0xF700B610, 0x02F9FEE4, 0xFE016C0E, 0x00000000},	/* 114 */
  {0x0F160530, 0x0904BA40, 0xF6FB45C0, 0x02F36F54, 0xFDF68B8C, 0x00000000},	/* 115 */
  {0x0F278950, 0x090A2980, 0xF6F5D680, 0x02ECC9B8, 0xFDEBACF0, 0x00000000},	/* 116 */
  {0x0F3921A0, 0x090F97D0, 0xF6F06830, 0x02E60E00, 0xFDE0D04C, 0x00000000},	/* 117 */
  {0x0F4ACE50, 0x09150530, 0xF6EAFAD0, 0x02DF3C08, 0xFDD5F5A8, 0x00000000},	/* 118 */
  {0x0F5C8F70, 0x091A7180, 0xF6E58E80, 0x02D85398, 0xFDCB1D04, 0x00000000},	/* 119 */
  {0x0F6E64F0, 0x091FDCC0, 0xF6E02340, 0x02D15498, 0xFDC04674, 0x00000000},	/* 120 */
  {0x0F804F10, 0x09254700, 0xF6DAB900, 0x02CA3EE8, 0xFDB57200, 0x00000000},	/* 121 */
  {0x0F924DF0, 0x092AB030, 0xF6D54FD0, 0x02C31260, 0xFDAA9FAC, 0x00000000},	/* 122 */
  {0x0FA461B0, 0x09301840, 0xF6CFE7C0, 0x02BBCED4, 0xFD9FCF84, 0x00000000},	/* 123 */
  {0x0FB68A40, 0x09357F30, 0xF6CA80D0, 0x02B47424, 0xFD9501A0, 0x00000000},	/* 124 */
  {0x0FC8C7D0, 0x093AE500, 0xF6C51B00, 0x02AD022C, 0xFD8A35F8, 0x00000000},	/* 125 */
  {0x0FDB1AA0, 0x094049B0, 0xF6BFB650, 0x02A578C8, 0xFD7F6C98, 0x00000000},	/* 126 */
  {0x0FED82A0, 0x0945AD30, 0xF6BA52D0, 0x029DD7D0, 0xFD74A588, 0x00000000},	/* 127 */
  {0x10000000, 0x094B0F90, 0xF6B4F070, 0x02961F24, 0xFD69E0DC, 0x00000000},	/* 128 */
  {0x101292E0, 0x095070B0, 0xF6AF8F50, 0x028E4E94, 0xFD5F1E94, 0x00000000},	/* 129 */
  {0x10253B40, 0x0955D0A0, 0xF6AA2F60, 0x02866600, 0xFD545EC0, 0x00000000},	/* 130 */
  {0x1037F940, 0x095B2F40, 0xF6A4D0C0, 0x027E6548, 0xFD49A170, 0x00000000},	/* 131 */
  {0x104ACD20, 0x09608CB0, 0xF69F7350, 0x02764C40, 0xFD3EE694, 0x00000000},	/* 132 */
  {0x105DB700, 0x0965E8E0, 0xF69A1720, 0x026E1ABC, 0xFD342E40, 0x00000000},	/* 133 */
  {0x1070B6E0, 0x096B43C0, 0xF694BC40, 0x0265D0A4, 0xFD297898, 0x00000000},	/* 134 */
  {0x1083CCC0, 0x09709D40, 0xF68F62C0, 0x025D6DC4, 0xFD1EC584, 0x00000000},	/* 135 */
  {0x1096F900, 0x0975F570, 0xF68A0A90, 0x0254F1F4, 0xFD141514, 0x00000000},	/* 136 */
  {0x10AA3BA0, 0x097B4C50, 0xF684B3B0, 0x024C5D18, 0xFD096754, 0x00000000},	/* 137 */
  {0x10BD94A0, 0x0980A1D0, 0xF67F5E30, 0x0243AF0C, 0xFCFEBC58, 0x00000000},	/* 138 */
  {0x10D10440, 0x0985F5F0, 0xF67A0A10, 0x023AE7A4, 0xFCF41420, 0x00000000},	/* 139 */
  {0x10E48AA0, 0x098B48A0, 0xF674B760, 0x023206B4, 0xFCE96EB8, 0x00000000},	/* 140 */
  {0x10F827C0, 0x099099F0, 0xF66F6610, 0x02290C18, 0xFCDECC20, 0x00000000},	/* 141 */
  {0x110BDBE0, 0x0995E9D0, 0xF66A1630, 0x021FF7A8, 0xFCD42C68, 0x00000000},	/* 142 */
  {0x111FA720, 0x099B3830, 0xF664C7D0, 0x0216C934, 0xFCC98F94, 0x00000000},	/* 143 */
  {0x113389A0, 0x09A08520, 0xF65F7AE0, 0x020D80AC, 0xFCBEF5BC, 0x00000000},	/* 144 */
  {0x11478360, 0x09A5D0A0, 0xF65A2F60, 0x02041DD4, 0xFCB45ED4, 0x00000000},	/* 145 */
  {0x115B94A0, 0x09AB1A90, 0xF654E570, 0x01FAA080, 0xFCA9CAF0, 0x00000000},	/* 146 */
  {0x116FBD40, 0x09B062F0, 0xF64F9D10, 0x01F1089A, 0xFC9F3A14, 0x00000000},	/* 147 */
  {0x1183FDA0, 0x09B5A9D0, 0xF64A5630, 0x01E755F6, 0xFC94AC60, 0x00000000},	/* 148 */
  {0x119855E0, 0x09BAEF20, 0xF64510E0, 0x01DD885E, 0xFC8A21B8, 0x00000000},	/* 149 */
  {0x11ACC600, 0x09C032E0, 0xF63FCD20, 0x01D39FBA, 0xFC7F9A40, 0x00000000},	/* 150 */
  {0x11C14E40, 0x09C57510, 0xF63A8AF0, 0x01C99BDA, 0xFC7515F0, 0x00000000},	/* 151 */
  {0x11D5EE80, 0x09CAB590, 0xF6354A70, 0x01BF7C8E, 0xFC6A94DC, 0x00000000},	/* 152 */
  {0x11EAA740, 0x09CFF480, 0xF6300B80, 0x01B541B6, 0xFC601704, 0x00000000},	/* 153 */
  {0x11FF7860, 0x09D531C0, 0xF62ACE40, 0x01AAEB22, 0xFC559C70, 0x00000000},	/* 154 */
  {0x12146220, 0x09DA6D60, 0xF62592A0, 0x01A078AC, 0xFC4B2530, 0x00000000},	/* 155 */
  {0x12296480, 0x09DFA750, 0xF62058B0, 0x0195EA34, 0xFC40B150, 0x00000000},	/* 156 */
  {0x123E7FC0, 0x09E4DFA0, 0xF61B2060, 0x018B3F7E, 0xFC3640C8, 0x00000000},	/* 157 */
  {0x1253B3E0, 0x09EA1630, 0xF615E9D0, 0x01807874, 0xFC2BD3AC, 0x00000000},	/* 158 */
  {0x12690120, 0x09EF4B00, 0xF610B500, 0x017594D4, 0xFC2169FC, 0x00000000},	/* 159 */
  {0x127E67A0, 0x09F47E20, 0xF60B81E0, 0x016A9490, 0xFC1703D0, 0x00000000},	/* 160 */
  {0x1293E780, 0x09F9AF70, 0xF6065090, 0x015F7764, 0xFC0CA120, 0x00000000},	/* 161 */
  {0x12A980E0, 0x09FEDF00, 0xF6012100, 0x01543D2E, 0xFC0241F8, 0x00000000},	/* 162 */
  {0x12BF33C0, 0x0A040CD0, 0xF5FBF330, 0x0148E5D0, 0xFBF7E668, 0x00000000},	/* 163 */
  {0x12D50060, 0x0A0938C0, 0xF5F6C740, 0x013D7118, 0xFBED8E78, 0x00000000},	/* 164 */
  {0x12EAE700, 0x0A0E62F0, 0xF5F19D10, 0x0131DED4, 0xFBE33A20, 0x00000000},	/* 165 */
  {0x1300E7A0, 0x0A138B40, 0xF5EC74C0, 0x01262EE2, 0xFBD8E978, 0x00000000},	/* 166 */
  {0x13170280, 0x0A18B1C0, 0xF5E74E40, 0x011A6100, 0xFBCE9C80, 0x00000000},	/* 167 */
  {0x132D3780, 0x0A1DD660, 0xF5E229A0, 0x010E752E, 0xFBC45348, 0x00000000},	/* 168 */
  {0x13438720, 0x0A22F920, 0xF5DD06E0, 0x01026B18, 0xFBBA0DC8, 0x00000000},	/* 169 */
  {0x1359F140, 0x0A2819F0, 0xF5D7E610, 0x00F642A1, 0xFBAFCC18, 0x00000000},	/* 170 */
  {0x13707620, 0x0A2D38E0, 0xF5D2C720, 0x00E9FBA3, 0xFBA58E40, 0x00000000},	/* 171 */
  {0x13871600, 0x0A3255F0, 0xF5CDAA10, 0x00DD95E1, 0xFB9B5428, 0x00000000},	/* 172 */
  {0x139DD0C0, 0x0A377100, 0xF5C88F00, 0x00D11143, 0xFB911E00, 0x00000000},	/* 173 */
  {0x13B4A6A0, 0x0A3C8A20, 0xF5C375E0, 0x00C46D9C, 0xFB86EBC8, 0x00000000},	/* 174 */
  {0x13CB97E0, 0x0A41A140, 0xF5BE5EC0, 0x00B7AAAA, 0xFB7CBD78, 0x00000000},	/* 175 */
  {0x13E2A4A0, 0x0A46B670, 0xF5B94990, 0x00AAC84D, 0xFB729318, 0x00000000},	/* 176 */
  {0x13F9CD00, 0x0A4BC9A0, 0xF5B43660, 0x009DC65F, 0xFB686CC0, 0x00000000},	/* 177 */
  {0x141110E0, 0x0A50DAD0, 0xF5AF2530, 0x0090A4B0, 0xFB5E4A68, 0x00000000},	/* 178 */
  {0x142870E0, 0x0A55E9F0, 0xF5AA1610, 0x00836300, 0xFB542C20, 0x00000000},	/* 179 */
  {0x143FECE0, 0x0A5AF710, 0xF5A508F0, 0x0076013A, 0xFB4A11E8, 0x00000000},	/* 180 */
  {0x14578520, 0x0A600220, 0xF59FFDE0, 0x00687F20, 0xFB3FFBC8, 0x00000000},	/* 181 */
  {0x146F3980, 0x0A650B10, 0xF59AF4F0, 0x005ADC9D, 0xFB35E9E0, 0x00000000},	/* 182 */
  {0x14870AA0, 0x0A6A1200, 0xF595EE00, 0x004D1961, 0xFB2BDC08, 0x00000000},	/* 183 */
  {0x149EF860, 0x0A6F16D0, 0xF590E930, 0x003F354A, 0xFB21D268, 0x00000000},	/* 184 */
  {0x14B702C0, 0x0A741980, 0xF58BE680, 0x00313035, 0xFB17CD00, 0x00000000},	/* 185 */
  {0x14CF2A40, 0x0A791A10, 0xF586E5F0, 0x002309F1, 0xFB0DCBD8, 0x00000000},	/* 186 */
  {0x14E76EA0, 0x0A7E1880, 0xF581E780, 0x0014C24B, 0xFB03CEF8, 0x00000000},	/* 187 */
  {0x14FFD0A0, 0x0A8314E0, 0xF57CEB20, 0x00065903, 0xFAF9D658, 0x00000000},	/* 188 */
  {0x15184FC0, 0x0A880EF0, 0xF577F110, 0xFFF7CE06, 0xFAEFE218, 0x00000000},	/* 189 */
  {0x1530ECC0, 0x0A8D06F0, 0xF572F910, 0xFFE92120, 0xFAE5F230, 0x00000000},	/* 190 */
  {0x1549A740, 0x0A91FCB0, 0xF56E0350, 0xFFDA5212, 0xFADC06A8, 0x00000000},	/* 191 */
  {0x15627FC0, 0x0A96F040, 0xF5690FC0, 0xFFCB60A9, 0xFAD21F70, 0x00000000},	/* 192 */
  {0x157B7660, 0x0A9BE1A0, 0xF5641E60, 0xFFBC4CD2, 0xFAC83CC0, 0x00000000},	/* 193 */
  {0x15948B20, 0x0AA0D0C0, 0xF55F2F40, 0xFFAD164B, 0xFABE5E80, 0x00000000},	/* 194 */
  {0x15ADBE80, 0x0AA5BDB0, 0xF55A4250, 0xFF9DBCD3, 0xFAB484A8, 0x00000000},	/* 195 */
  {0x15C71060, 0x0AAAA850, 0xF55557B0, 0xFF8E4056, 0xFAAAAF58, 0x00000000},	/* 196 */
  {0x15E080A0, 0x0AAF90B0, 0xF5506F50, 0xFF7EA0A3, 0xFAA0DE98, 0x00000000},	/* 197 */
  {0x15FA1020, 0x0AB476D0, 0xF54B8930, 0xFF6EDD77, 0xFA971258, 0x00000000},	/* 198 */
  {0x1613BEC0, 0x0AB95AB0, 0xF546A550, 0xFF5EF6A1, 0xFA8D4AA8, 0x00000000},	/* 199 */
  {0x162D8C80, 0x0ABE3C30, 0xF541C3D0, 0xFF4EEBFD, 0xFA838798, 0x00000000},	/* 200 */
  {0x16477980, 0x0AC31B60, 0xF53CE4A0, 0xFF3EBD5B, 0xFA79C930, 0x00000000},	/* 201 */
  {0x16618620, 0x0AC7F850, 0xF53807B0, 0xFF2E6A85, 0xFA700F60, 0x00000000},	/* 202 */
  {0x167BB280, 0x0ACCD2E0, 0xF5332D20, 0xFF1DF33D, 0xFA665A48, 0x00000000},	/* 203 */
  {0x1695FEC0, 0x0AD1AB20, 0xF52E54E0, 0xFF0D575C, 0xFA5CA9D0, 0x00000000},	/* 204 */
  {0x16B06B40, 0x0AD68100, 0xF5297F00, 0xFEFC96B2, 0xFA52FE18, 0x00000000},	/* 205 */
  {0x16CAF7E0, 0x0ADB5470, 0xF524AB90, 0xFEEBB0FE, 0xFA495718, 0x00000000},	/* 206 */
  {0x16E5A520, 0x0AE025A0, 0xF51FDA60, 0xFEDAA62A, 0xFA3FB4D8, 0x00000000},	/* 207 */
  {0x170072C0, 0x0AE4F450, 0xF51B0BB0, 0xFEC975E6, 0xFA361768, 0x00000000},	/* 208 */
  {0x171B6140, 0x0AE9C0A0, 0xF5163F60, 0xFEB8200E, 0xFA2C7EC0, 0x00000000},	/* 209 */
  {0x173670C0, 0x0AEE8A90, 0xF5117570, 0xFEA6A470, 0xFA22EAF0, 0x00000000},	/* 210 */
  {0x1751A140, 0x0AF35210, 0xF50CADF0, 0xFE9502C6, 0xFA195BE8, 0x00000000},	/* 211 */
  {0x176CF340, 0x0AF81710, 0xF507E8F0, 0xFE833AF4, 0xFA0FD1C8, 0x00000000},	/* 212 */
  {0x178866C0, 0x0AFCD9B0, 0xF5032650, 0xFE714CC4, 0xFA064C90, 0x00000000},	/* 213 */
  {0x17A3FBC0, 0x0B0199E0, 0xF4FE6620, 0xFE5F37F0, 0xF9FCCC38, 0x00000000},	/* 214 */
  {0x17BFB2E0, 0x0B0657A0, 0xF4F9A860, 0xFE4CFC5C, 0xF9F350D0, 0x00000000},	/* 215 */
  {0x17DB8BE0, 0x0B0B12D0, 0xF4F4ED30, 0xFE3A99BE, 0xF9E9DA60, 0x00000000},	/* 216 */
  {0x17F78720, 0x0B0FCB90, 0xF4F03470, 0xFE280FE6, 0xF9E068E0, 0x00000000},	/* 217 */
  {0x1813A4E0, 0x0B1481D0, 0xF4EB7E30, 0xFE155EA4, 0xF9D6FC68, 0x00000000},	/* 218 */
  {0x182FE580, 0x0B193590, 0xF4E6CA70, 0xFE0285BC, 0xF9CD94E0, 0x00000000},	/* 219 */
  {0x184C4880, 0x0B1DE6D0, 0xF4E21930, 0xFDEF8508, 0xF9C43270, 0x00000000},	/* 220 */
  {0x1868CEA0, 0x0B229580, 0xF4DD6A80, 0xFDDC5C3C, 0xF9BAD508, 0x00000000},	/* 221 */
  {0x18857820, 0x0B2741B0, 0xF4D8BE50, 0xFDC90B34, 0xF9B17CA8, 0x00000000},	/* 222 */
  {0x18A244E0, 0x0B2BEB50, 0xF4D414B0, 0xFDB591B4, 0xF9A82960, 0x00000000},	/* 223 */
  {0x18BF3560, 0x0B309270, 0xF4CF6D90, 0xFDA1EF84, 0xF99EDB38, 0x00000000},	/* 224 */
  {0x18DC4940, 0x0B3536E0, 0xF4CAC920, 0xFD8E2474, 0xF9959230, 0x00000000},	/* 225 */
  {0x18F98180, 0x0B39D8E0, 0xF4C62720, 0xFD7A304C, 0xF98C4E40, 0x00000000},	/* 226 */
  {0x1916DDA0, 0x0B3E7840, 0xF4C187C0, 0xFD6612C8, 0xF9830F80, 0x00000000},	/* 227 */
  {0x19345E60, 0x0B431510, 0xF4BCEAF0, 0xFD51CBBC, 0xF979D5F0, 0x00000000},	/* 228 */
  {0x19520380, 0x0B47AF40, 0xF4B850C0, 0xFD3D5AF0, 0xF970A190, 0x00000000},	/* 229 */
  {0x196FCD80, 0x0B4C46D0, 0xF4B3B930, 0xFD28C030, 0xF9677260, 0x00000000},	/* 230 */
  {0x198DBC60, 0x0B50DBD0, 0xF4AF2430, 0xFD13FB38, 0xF95E4868, 0x00000000},	/* 231 */
  {0x19ABD080, 0x0B556E20, 0xF4AA91E0, 0xFCFF0BDC, 0xF95523B0, 0x00000000},	/* 232 */
  {0x19CA09C0, 0x0B59FDE0, 0xF4A60220, 0xFCE9F1E0, 0xF94C0440, 0x00000000},	/* 233 */
  {0x19E868E0, 0x0B5E8B00, 0xF4A17500, 0xFCD4AD00, 0xF942EA10, 0x00000000},	/* 234 */
  {0x1A06EDE0, 0x0B631570, 0xF49CEA90, 0xFCBF3D04, 0xF939D528, 0x00000000},	/* 235 */
  {0x1A2598A0, 0x0B679D30, 0xF49862D0, 0xFCA9A1C8, 0xF930C598, 0x00000000},	/* 236 */
  {0x1A446980, 0x0B6C2250, 0xF493DDB0, 0xFC93DB14, 0xF927BB58, 0x00000000},	/* 237 */
  {0x1A636100, 0x0B70A4D0, 0xF48F5B30, 0xFC7DE898, 0xF91EB668, 0x00000000},	/* 238 */
  {0x1A827F20, 0x0B752490, 0xF48ADB70, 0xFC67CA20, 0xF915B6D8, 0x00000000},	/* 239 */
  {0x1AA1C400, 0x0B79A1B0, 0xF4865E50, 0xFC517F68, 0xF90CBC98, 0x00000000},	/* 240 */
  {0x1AC12FE0, 0x0B7E1C20, 0xF481E3E0, 0xFC3B0858, 0xF903C7C8, 0x00000000},	/* 241 */
  {0x1AE0C320, 0x0B8293D0, 0xF47D6C30, 0xFC24649C, 0xF8FAD860, 0x00000000},	/* 242 */
  {0x1B007DC0, 0x0B8708D0, 0xF478F730, 0xFC0D93EC, 0xF8F1EE58, 0x00000000},	/* 243 */
  {0x1B206000, 0x0B8B7B20, 0xF47484E0, 0xFBF69630, 0xF8E909C8, 0x00000000},	/* 244 */
  {0x1B406A60, 0x0B8FEAB0, 0xF4701550, 0xFBDF6B08, 0xF8E02A98, 0x00000000},	/* 245 */
  {0x1B609CC0, 0x0B945790, 0xF46BA870, 0xFBC81258, 0xF8D750D8, 0x00000000},	/* 246 */
  {0x1B80F780, 0x0B98C1B0, 0xF4673E50, 0xFBB08BD8, 0xF8CE7CA0, 0x00000000},	/* 247 */
  {0x1BA17AE0, 0x0B9D2910, 0xF462D6F0, 0xFB98D748, 0xF8C5ADE0, 0x00000000},	/* 248 */
  {0x1BC22720, 0x0BA18DB0, 0xF45E7250, 0xFB80F468, 0xF8BCE490, 0x00000000},	/* 249 */
  {0x1BE2FC40, 0x0BA5EFA0, 0xF45A1060, 0xFB68E2F8, 0xF8B420D0, 0x00000000},	/* 250 */
  {0x1C03FAC0, 0x0BAA4EC0, 0xF455B140, 0xFB50A2D0, 0xF8AB6290, 0x00000000},	/* 251 */
  {0x1C2522A0, 0x0BAEAB20, 0xF45154E0, 0xFB3833A0, 0xF8A2A9D0, 0x00000000},	/* 252 */
  {0x1C467420, 0x0BB304B0, 0xF44CFB50, 0xFB1F9530, 0xF899F6A0, 0x00000000},	/* 253 */
  {0x1C67EFA0, 0x0BB75B80, 0xF448A480, 0xFB06C750, 0xF8914908, 0x00000000},	/* 254 */
  {0x1C899580, 0x0BBBAF90, 0xF4445070, 0xFAEDC9A0, 0xF888A0E0, 0x00000000},	/* 255 */
  {0x1CAB6560, 0x0BC000C0, 0xF43FFF40, 0xFAD49C10, 0xF87FFE70, 0x00000000},	/* 256 */
  {0, 0, 0, 0, 0, 0}
};
