NAME
softoss - Virtual Mixer audio driver.

DESCRIPTION
Open Sound System provides an audio mixer device to mix multiple
audio streams being played to the same audio device.


 INTRODUCTION
Virtual Mixer is a feature of Open Sound System to overcome the problem of
applications making exclusive write access to audio devices. The Virtual
Mixer allows multiple concurrent audio applications to run and the output
from each application is mixed and sample rate converted to the highest
sampling rate of the soundcard hardware (typically 48Khz/stereo/16bit).

The normal Virtual Mixer mode is enabled by default and you don't need to do
anything to enable it. It can be disabled by using the "Configuration options
(options.cfg)" editor of soundconf command and by setting the value of
softoss_disable to 1.

To use the pro mode you should first enable it by configuring the
virtual mixer driver. This can be done by adding the "4Front Virtual Mixer Pro"
device using the "Add new card/device" function of soundconf. 

By default only 8 virtual devices will be created. If you need more you
need to edit the softoss.conf (see below) and set the value of the softoss_devices option. Upto 32 devices can be configured.

After the virtual mixer driver is installed the additional audio
devices will be shown as below by ossinfo -a.

	Audio devices:

	0: Creative AudioPCI (DUPLEX)
	1: Creative AudioPCI (playback only)
	2: SoftOSS v2.5 CH #0
	3: SoftOSS v2.5 CH #1
	4: SoftOSS v2.5 CH #2
	5: SoftOSS v2.5 CH #3
	6: SoftOSS v2.5 CH #4
	7: SoftOSS v2.5 CH #5
	8: SoftOSS v2.5 CH #6
	9: SoftOSS v2.5 CH #7

In the above case the first virtual mixer device is /dev/dsp2 (/dev/audio2)
and the last one is /dev/dsp9 (/dev/audio9). You can have up to 8 of these
devices active at the same time. Note that the "real" audio device (usually
/dev/dsp0) will not be available while any of the virtual mixer devices
are open. Also the virtual mixer devices cannot be used while the actual
hardware device (/dev/dsp0) is open.

 IMPROVING SOUND QUALITY

The method used for sample rate conversion by the virtual mixer is optimized
for CPU speed. The drawback is that sound quality is not perfect (should be
enough for most users).

There is now an alternative sample rate conversion filter available.
This converter provides quality that cannot be outperformed. It
consumes more CPU power which means it's not suitable to be used with slower
than Pentium III or AMD K7 machines. In fast machines the additional CPU
overhead caused by the filter is about 1-3% (for each simultaneously active
virtual device). In the current version of OSS this algorithm is enabled by
default. To disable this feature you need to add a line containing
softoss_use_src=0 to the options.cfg file.

FEATURES
1. Setting the number of Virtual Mixer devices
You can now configure the number of Virtual Mixer devices by running
soundconf, select Configuration Options and then select the option
"softoss_devices" and type in the number of devices between 4 and 48. 
Save the configuration and run soundon.
2. Volume Control:
You now have the ability to control the individual volumes for each of 
the Virtual Mixer channels. To do this you must use the ossxmix program 
located in the OSS installation directory. Find out the Virtual Mixer's 
mixer device number by typing ossinfo -a and then type ossxmix -d# 
(for example, if the Virtual Mixer's mixer device is device number 1 then 
type ossxmix -d1)
3. Equalizer:
Virtual Mixer also provides you with a Professional Grade 4 band
equalizer. By default this equalizer is disabled. To enable th equalizer,
uncheck the "Bypass" button and now moving the equalizer sliders will
enable you to change the sound output.
4. Loopback Recording:
Virtual Mixer now enables you to record any audio that's played
on the playback channel. The recording is completely sample rate
controlled which means that even if you are playing audio at a
given sample rate, bits per sample and stere/mono, you can record
that same audio in a completely different speed/bits/channels.
For example, you can play a mp3 (44.1Khz/16bit/Stereo) on SoftOSS i
playback channel 0 and record that same mp3 at 22Khz 8bit mono.
The loopback recording mode in the Virtual Mixer can be enabled by
running soundconf->select Configuration Options->select softoss_loopdevs
and type in a number between 1 and 48 in the box. Save the configuration
and exit and now run soundon.
5. Setting the Sampling Rate:
By default Virtual Mixer uses the maximum sampling rate of the soundcard.
For instance, the Sound Blaster AWE64 only supports 44.1Khz while the
Sound Blaster PCI128 supports 48Khz. Virtual Mixer will do sample rate
conversion against the maximum sampling rate of the device. In some 
instances you may want to force a lower sampling rate like 44.1Khz on
a sound card that does 48Khz (typically if you are processing CD audio
in CDDA mode which will create PCM audio at 44.1Khz. In this case you
wouldn't want the audio to be up sampled to 48Khz). To change the
sampling rate of the Virtual Mixer, run soundconf, select Configuration
Options menu, select "softoss_rate" and then enter the sampling rate
desired. The legal values are 11025, 22050, 32000, 44100 and 48000.
6. Open redirect:
If an application tries to open the "physical" device used by SoftOSS
the open will be redirected to the virtual devices. This makes sharing
the device between multiple applications very easy. 
7. Effects:
The SoftOSS virtual mixer provides the following audio effects that apply to
any audio playing via the Virtual Mixer:

	o Reverb: This feature adds simple reverb effects to audio. 
	o Fidelity Enhance: This feature adds "fidelity" or "brightness"
to audio like MP3 and Ogg. This feature is also known as "exciters" in audio terminology. 
	o 3D Audio: This feature spreads the stereo field giving the listner the impression that the audio is coming from speakers in front and side of the listners ears.

 CPU USAGE

The virtual mixer driver consumes some additional CPU time when compared
to a "real" hardware device. This extra load is barely measurable on fast
systems.

However the load may be very significant on older (486) systems. When the load
on a fast 1.5GHz PII/P4/K7 system is just few percents it can be 50% or more
on slow (486 and oldest Pentium) CPUs.

On a PIII/686 system the "iddle" load when none of the virtual devices is 
playing audio is about 5% of CPU time. The load gets increased by 1.5% for
each active (playing) virtual device. This measurement was made when the
master device was running at 48 kHz and each of the virtual devices were
outputting 44.1 kHz stream. Low quality SRC (Sample Rate Conversion) algorithm
was used (softoss_use_src option was set to 0).

When the sampling rate of the virtual stream equals to the sampling rate
of the master device the load increase caused by an active virtual device
was just 0.3%.

Using the professional quality SRC algorithm (GRC3) the load increase caused by
each active virtual channel is just slightly larger than with the low quality
SRC method. The measured difference (PII/866) was about 0.3%.

 MINIMIZING CPU USAGE

Minimizing the CPU usage of the virtual mixer driver may be necessary when
using slower CPUs (such as most processors designed for embedded systems).
There are several ways to do this:

1. Decrease the sampling rate used by the by the master device by setting
the softoss_rate option in options.cfg. The decrease in the CPU usage is
proportional with the decrease in the sampling rate. In ideal case use the same
sampling rate as majority of the sounds to be played.
2. Whenever possible use the same sampling rate in the virtual devices as the
one used by the master device (softoss_rate option). When the sampling rates
match the time consuming sample rate conversion step can be skipped. This
decreases the CPU load associated with an active virtual device to 1/5th of
the case where the sampling rates are different.
3. In some situations using the lower quality SRC algorithm may help.
This can be done by setting the softoss_use_src option to 0 in options.cfg.
However in some cases using this method may actually make things worse since
the low auality SRC code is executed in the interrupt context.

Notice that the virtual mixer driver will use some CPU time always when
any of the virtual devices are open even none of them is actually outputting
anything. This "base load" equals to the CPU time taken by 3 active virtual
channels (when SRC is used).

OPTIONS
o softoss_rate:           Specifies the sampling rate for Virtual Mixer -
                        normally its set to the highest frequency of the
                        soundcard eg 48000. However if you want Virtual Mixer
                        to use 44.1Khz then specify 44100.
                                Values: 5000-96000 Default: 48000

o softoss_masterdev:      This tells Virtual Mixer which physical device to use.
                        Type cat ossinfo -a and locate the physical devices
                        from the list and then set softoss_masterdev to one.
                        Normally this parameter defaults to the first playback
                        only or Duplex device (if no playback only device is
                        available)
                                Values: 1-number of physical devices, Default: 0

o softoss_channels:       Specifies how many interleaved channels to use.
                                Values: 1,2,4,6 Default: 2 (stereo)

o softoss_devices:        Specifies how many /dev/dsps to configure.
                                Values: 1-32    Default: 8

o softoss_loopdevs:       Specifies how many loopback recording devices to
                        configure in Virtual Mixer PRO.
                                Values: 1-4     Default: 0

o softoss_redirect:       Specifies if you want OSS to automatically set /dev/dsp
                        to open a Virtual Mixer channel.
                                Values: 1 or 0  Default: 1

o softoss_disable:        Specifies if you want to disable Virtual Mixer and OSS
                        will not load the virtual mixer devices.
                                Values: 1 or 0  Default 0

o softoss_use_src:        Turns on the 4Front GRC Professional sample rate
                        convertors. If disabled, Virtual Mixer defaults to a
                        linear interpolated SRC.
                                Values: 1 or 0  Default: 1

o softoss_fragment:       Specifies the DSP_SET_FRAGMENT setting. Some apps
                        require small fragments for better performance.
                                Values: 1-15    Default: 7
FILES
CONFIGFILEPATH/softoss.conf Device configuration file

AUTHOR
4Front Technologies
