/*
 * Purpose: OSS core pseudo driver (for Solaris)
 *
 * The osscore driver is used under Solaris to load the configuration settings 
 * (osscore.conf) and to install the /dev/sndstat device.
 */
/*
 *
 * This file is part of Open Sound System.
 *
 * Copyright (C) 4Front Technologies 1996-2008.
 *
 * This this source file is released under GPL v2 license (no other versions).
 * See the COPYING file included in the main directory of this source
 * distribution for the license terms and conditions.
 *
 */

#include "osscore_cfg.h"
extern int oss_expired;

int
osscore_attach (oss_device_t * osdev)
{
#ifdef LICENSED_VERSION
  timestruc_t ts;

  gethrestime (&ts);
  if (!oss_license_handle_time (ts.tv_sec))
    {
      cmn_err (CE_WARN, "This version of Open Sound System has expired\n");
      cmn_err (CE_CONT,
               "Please download the latest version from www.opensound.com\n");
      oss_expired = 1;
    }
#endif


  oss_register_device (osdev, "OSS common devices");
  oss_common_init (osdev);
  return 1;
}

int
osscore_detach (oss_device_t * osdev)
{
  if (oss_disable_device (osdev) < 0)
    return 0;

  oss_unload_drivers ();
  oss_unregister_device (osdev);

  return 1;
}
