NAME
ossmix - Open Sound System command-line mixer applet.

DESCRIPTION
ossmix is a simple mixer utility which is designed to replace the mixer applet
originally included with OSS. OSS version 4 has extended mixer API which 
supports some device specific features that are not accessible using other
mixers applications. 


 USAGE
ossmix -h displays short instructions for using ossmix.

ossmix without any arguments displays the current settings of the
default mixer device (usually the motherboard sound chip). This
printout can also be used to find out the supported control names and
their possible values. Currently all controls accept an ON/OFF value, a
mono value (0 to 100) or a stereo value (left:right where both channel
volumes can be between 0 and 100). The following is a sample printout
produced by ossmix:

	Selected mixer 0/Creative AudioPCI
	Known controls are:
	vol <both/leftvol>[:<rightvol>] (currently 50:50)
	pcm <both/leftvol>[:<rightvol>] (currently 50:50)
	speaker <monovol> (currently 21)
	line <both/leftvol>[:<rightvol>] (currently 32:32)
	line.rec ON|OFF (currently OFF)
	mic <monovol> (currently 16)
	mic.rec ON|OFF (currently ON)
	cd <both/leftvol>[:<rightvol>] (currently 100:100)
	cd.rec ON|OFF (currently OFF)
	pcm2 <both/leftvol>[:<rightvol>] (currently 75:75)
	line1 <both/leftvol>[:<rightvol>] (currently 32:32)
	line1.rec ON|OFF (currently OFF)
	line2 <monovol> (currently 32)
	line2.rec ON|OFF (currently OFF)
	line3 <monovol> (currently 0)
	line3.rec ON|OFF (currently OFF)
	mic.micboost ON|OFF (currently ON)
	mic.micbias ON|OFF (currently ON)
	mute.pcmmute ON|OFF (currently OFF)
	mute.pcm2mute ON|OFF (currently OFF)
	mute.micmute ON|OFF (currently OFF)
	mute.cdmute ON|OFF (currently OFF)
	mute.linemute ON|OFF (currently OFF)
	mute.line1mute ON|OFF (currently OFF)
	mute.line2mute ON|OFF (currently OFF)
	mute.line3mute ON|OFF (currently OFF)

 SELECTING MIXER DEVICE

It's possible to select the mixer device by using the -d<mixernumber>
command line argument. This argument (when used) should be the first one
on the command line. By default the mixer number 0 will be accessed.
To find the available mixer devices, type ossinfo -x and look
under the Mixers heading for available mixer devices. 


 CHANGING MIXER SETTINGS

Changing the values is done just like with the original "mixer" applet.
For example:

	ossmix pcm 50:60

The above sets the pcm control (audio playback volume) so that the left
channel volume is 50 and the right channel volume is 60. With just
"ossmix pcm 50" the both channel volumes will be set to 50.

In addition to the old mixer there are now some new (usually ON/OFF) settings
which were not supported before OSS 3.9. These settings are device specific
and don't work with all soundcards. The easiest way to find them out is
to start ossmix without command line arguments (other than -d#).

Some control names contain a dot ("."). This dot is required when changing
the value. For example: "ossmix -d0 mic.micboost ON".

FILES
/usr/bin/ossmix

AUTHOR
4Front Technologies.
