#!/bin/sh
#name it
EXTN="mediaswg-vol.tce"
#remove the last one
[ ! -e ../usr ] || rm -rf ../usr

#copy stuff
mkdir -p ../usr/local/mediaswg/LICENSE/
cp -Ra usr/local/bin ../usr/local
cp -Ra usr/local/mediaswg/bin ../usr/local/mediaswg/
cp -Ra usr/local/tce.installed ../usr/local/
cp -Ra usr/local/tce.menu ../usr/local/
cp -Ra usr/local/mediaswg/LICENSE/mediaswg-vol ../usr/local/mediaswg/LICENSE/

#tar the skel
mkdir -p ../usr/local/mediaswg/skel
cd usr/local/mediaswg/skel
find ./.mediaswg -not -type d >../../../../skel.lst
tar -zcvf ../../../../../usr/local/mediaswg/skel/vol.tgz -T ../../../../skel.lst
cd ../../../../
rm -f skel.lst

#compile watcher2h
export CFLAGS="-march=i486 -mtune=i686 -Os -pipe"
export CXXFLAGS="-march=i486 -mtune=i686 -Os -pipe -fno-exceptions -fno-rtti"
export PKG_CONFIG_PATH=/usr/local/lib/pkgconfig:/usr/lib/pkgconfig
g++ -Os -fno-exceptions -fno-rtti -lfltk -o ../usr/local/bin/watcher2h sources/watcher2h.cxx
strip ../usr/local/bin/watcher2h
chmod 755 ../usr/local/bin/watcher2h

#package it all up for shipping
cd ../
[ -d tcesubmit/files ] || mkdir -p tcesubmit/files
find usr/ -not -type d >"$EXTN".lst
find src/ -not -type d >"$EXTN".src.lst
tar -zcvf tcesubmit/files/"$EXTN" -T "$EXTN".lst
echo
tar -zcvf tcesubmit/files/"$EXTN".src.tgz -T "$EXTN".src.lst
echo
rm -f "$EXTN".lst "$EXTN".src.lst
cd tcesubmit/files
md5sum "$EXTN" >"$EXTN".md5.txt
tar -ztf "$EXTN" >"$EXTN".list
echo
cd ../
find files/ -not -type d >files.list
tar -zcvf "$EXTN".tar.gz -T files.list
rm -f files.list
bcrypt -r "$EXTN".tar.gz

#uncomment this line to stop here
#exit 0

#and add it to my tce directory
cp files/"$EXTN" /mnt/sda1/tce/"$EXTN"
chown tc:staff /mnt/sda1/tce/"$EXTN"




