/*
 * Utility functions for switching tools (= contexts)
 *
 * Authors:
 *   bulia byak <bulia@dr.com>
 *
 * Copyright (C) 2003 authors
 *
 * Released under GNU GPL, read the file 'COPYING' for more information
 */

#ifndef SEEN_TOOLS_SWITCH_H
#define SEEN_TOOLS_SWITCH_H

#include <forward.h>

enum {
  TOOLS_INVALID,
  TOOLS_SELECT,
  TOOLS_NODES,
  TOOLS_TWEAK,
  TOOLS_SHAPES_RECT,
  TOOLS_SHAPES_3DBOX,
  TOOLS_SHAPES_ARC,
  TOOLS_SHAPES_STAR,
  TOOLS_SHAPES_SPIRAL,
  TOOLS_FREEHAND_PENCIL,
  TOOLS_FREEHAND_PEN,
  TOOLS_CALLIGRAPHIC,
  TOOLS_TEXT,
  TOOLS_GRADIENT,
  TOOLS_ZOOM,
  TOOLS_DROPPER,
  TOOLS_CONNECTOR,
  TOOLS_PAINTBUCKET,
  TOOLS_ERASER,
  TOOLS_LPETOOL
};

int tools_isactive(SPDesktop *dt, unsigned num);
int tools_active(SPDesktop *dt);
void tools_switch(SPDesktop *dt, int num);
void tools_switch_by_item (SPDesktop *dt, SPItem *item);

#endif /* !SEEN_TOOLS_SWITCH_H */

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4 :
