/*
 * Copyright (c) 2003 World Wide Web Consortium,
 *
 * (Massachusetts Institute of Technology, European Research Consortium for
 * Informatics and Mathematics, Keio University). All Rights Reserved. This
 * work is distributed under the W3C(r) Software License [1] in the hope that
 * it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * [1] http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231
 */

package org.w3c.dom.events;

import org.w3c.dom.views.AbstractView;

/**
 * The <code>TextEvent</code> interface provides specific contextual 
 * information associated with Text Events. 
 * <p> To create an instance of the <code>TextEvent</code> interface, use the 
 * <code>DocumentEvent.createEvent("TextEvent")</code> method call. 
 * <p>See also the <a href='http://www.w3.org/TR/2003/NOTE-DOM-Level-3-Events-20031107'>Document Object Model (DOM) Level 3 Events Specification</a>.
 * @since DOM Level 3
 */
public interface TextEvent extends UIEvent {
    /**
     *  <code>data</code> holds the value of the characters generated by the 
     * character device. This may be a single Unicode character or a 
     * non-empty sequence of Unicode characters [Unicode]. Characters should be normalized as defined by the Unicode 
     * normalization form NFC, defined in [<a href='http://www.unicode.org/unicode/reports/tr15/'>UTR #15</a>]. This 
     * attribute cannot be null or contain the empty string. 
     */
    public String getData();

    /**
     *  The <code>initTextEvent</code> method is used to initialize the value 
     * of a <code>TextEvent</code> object and has the same behavior as 
     * <code>UIEvent.initUIEvent()</code>. The value of 
     * <code>UIEvent.detail</code> remains undefined. 
     * @param typeArg  Refer to the <code>UIEvent.initUIEvent()</code> method 
     *   for a description of this parameter. 
     * @param canBubbleArg  Refer to the <code>UIEvent.initUIEvent()</code> 
     *   method for a description of this parameter. 
     * @param cancelableArg  Refer to the <code>UIEvent.initUIEvent()</code> 
     *   method for a description of this parameter. 
     * @param viewArg  Refer to the <code>UIEvent.initUIEvent()</code> method 
     *   for a description of this parameter. 
     * @param dataArg  Specifies <code>TextEvent.data</code>. 
     */
    public void initTextEvent(String typeArg, 
                              boolean canBubbleArg, 
                              boolean cancelableArg, 
                              AbstractView viewArg, 
                              String dataArg);

    /**
     *  The <code>initTextEventNS</code> method is used to initialize the 
     * value of a <code>TextEvent</code> object and has the same behavior as 
     * <code>UIEvent.initUIEventNS()</code>. The value of 
     * <code>UIEvent.detail</code> remains undefined. 
     * @param namespaceURI  Refer to the <code>UIEvent.initUIEventNS()</code> 
     *   method for a description of this parameter. 
     * @param type  Refer to the <code>UIEvent.initUIEventNS()</code> method 
     *   for a description of this parameter. 
     * @param canBubbleArg  Refer to the <code>UIEvent.initUIEventNS()</code> 
     *   method for a description of this parameter. 
     * @param cancelableArg  Refer to the <code>UIEvent.initUIEventNS()</code>
     *    method for a description of this parameter. 
     * @param viewArg  Refer to the <code>UIEvent.initUIEventNS()</code> 
     *   method for a description of this parameter. 
     * @param dataArg  Refer to the <code>TextEvent.initTextEvent()</code> 
     *   method for a description of this parameter. 
     */
    public void initTextEventNS(String namespaceURI, 
                                String type, 
                                boolean canBubbleArg, 
                                boolean cancelableArg, 
                                AbstractView viewArg, 
                                String dataArg);

}
