/*   FILE: xscreensaver.c --  */
/* AUTHOR: W. Michael Petullo <mike@flyn.org> */
/*   DATE: 20 July 2002 */
/*  */
/* Copyright (C) 2002 W. Michael Petullo <mike@flyn.org> */
/* All rights reserved. */
/*  */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or */
/* (at your option) any later version. */
/*  */
/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */
/*  */
/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to the Free Software */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include <config.h>
#include <unistd.h>
#include <remote.h>
#include <pthread.h>

#ifdef HAVE_XSCREENSAVER

int timeout, interval, prefer_blanking, allow_exposures;

int xscreensaver_disabled;
pthread_t xscreensaver_thread;

/* ============================ do_xscreensaver_disable () ================= */
void *do_xscreensaver_disable(void *param)
{
    int status;
    char *err;
    Atom XA_DEACTIVATE;
    Display *display = XOpenDisplay(NULL);
    if (!display) {
	pthread_exit(NULL);
    }
    XA_DEACTIVATE = XInternAtom(display, "DEACTIVATE", False);
    xscreensaver_init(display);
    while (xscreensaver_disabled) {
	status = xscreensaver_command(display, XA_DEACTIVATE, 0, 0, &err);
	if (status) {
	    break;
	}
	sleep(30);
    }
    XCloseDisplay(display);
    pthread_exit(NULL);
}

/* ============================ xscreensaver_initialize () ================= */
int xscreensaver_initialize(void)
{
    Display *display = XOpenDisplay(NULL);
    XGetScreenSaver(display, &timeout, &interval, &prefer_blanking, &allow_exposures);
    XCloseDisplay(display);
    return 0;
}

/* ============================ xscreensaver_disable () ==================== */
int xscreensaver_disable(void)
{
    Display *display = XOpenDisplay(NULL);
    XSetScreenSaver(display, 0, 0, DefaultBlanking, DefaultExposures);
    xscreensaver_disabled = 1;
    pthread_create(&xscreensaver_thread, NULL, do_xscreensaver_disable, NULL);
    XCloseDisplay(display);
    return 0;
}

/* ============================ xscreensaver_enable () ===================== */
int xscreensaver_enable(void)
{
    Display *display = XOpenDisplay(NULL);
    XSetScreenSaver(display, -1, 0, DefaultBlanking, DefaultExposures);
    xscreensaver_disabled = 0;
    pthread_detach(xscreensaver_thread);
    XCloseDisplay(display);
    return 0;
}

/* ============================ xscreensaver_restore () ==================== */
int xscreensaver_restore(void)
{
    Display *display = XOpenDisplay(NULL);
    xscreensaver_disabled = 0;
    pthread_detach(xscreensaver_thread);
    XSetScreenSaver(display, timeout, interval, prefer_blanking, allow_exposures);
    XCloseDisplay(display);
    return 0;
}

#endif /* HAVE_XSCREENSAVER */
