/*   FILE: libss.c --  */
/* AUTHOR: W. Michael Petullo <mike@flyn.org> */
/*   DATE: 19 July 2002 */
/*  */
/* Copyright (C) 2002 W. Michael Petullo <mike@flyn.org> */
/* All rights reserved. */
/*  */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or */
/* (at your option) any later version. */
/*  */
/* This program is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */
/*  */
/* You should have received a copy of the GNU General Public License */
/* along with this program; if not, write to the Free Software */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include <config.h>
#include <libss.h>
#include <dlfcn.h>

#ifdef HAVE_XSCREENSAVER
extern int xscreensaver_initialize (void);
extern int xscreensaver_enable (void);
extern int xscreensaver_disable (void);
extern int xscreensaver_restore (void);
#endif /* HAVE_XSCREENSAVER */

/* ============================ screensaver_init () ======================== */
ss_device_t screensaver_init(void)
{
    /* Okay this isn't quite there yet.  I am considering using dlopen,
     * but I will have to look into its portability.  Else this will be set
     * up at compile time.
     */

    ss_device_t x;
#ifdef HAVE_XSCREENSAVER
    x.initially_on = 1;
    x.name = "XScreenSaver";
    x.screensaver_enable = xscreensaver_enable;
    x.screensaver_disable = xscreensaver_disable;
    x.screensaver_restore = xscreensaver_restore;
    xscreensaver_initialize ();
#endif /* HAVE_XSCREENSAVER */
    return x;
}

/* ============================ screensaver_enable () ====================== */
int screensaver_enable(ss_device_t x)
{
    return x.screensaver_enable();
}

/* ============================ screensaver_disable () ===================== */
int screensaver_disable(ss_device_t x)
{
    return x.screensaver_disable();
}

/* ============================ screensaver_restore () ===================== */
int screensaver_restore(ss_device_t x)
{
    return x.screensaver_restore();
}
